% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{create_transformations}
\alias{create_transformations}
\title{Create Candidate Transformations}
\usage{
create_transformations(
  data,
  transformations = NULL,
  variables = NULL,
  cols = NULL
)
}
\arguments{
\item{data}{Data frame.}

\item{transformations}{List of formulas specifying transformations.}

\item{variables}{Character vector of variable names (alternative interface).}

\item{cols}{Alias for variables.}
}
\value{
Data frame with transformation columns added.
}
\description{
Generates derived variables based on specified transformations that may
be theoretically relevant.
}
\examples{
data <- data.frame(X = 1:10, Y = 10:1)

# Simple interface
data <- create_transformations(data, variables = c("X", "Y"))

# Formula interface
data <- create_transformations(data, transformations = list(
  ratios = ~ X/Y
))

}
