% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{plot_FluxPoint}
\alias{plot_FluxPoint}
\title{Plot multivariate time series with detected change points and estimated means}
\usage{
plot_FluxPoint(data, muhats, cps, titlename = "", xaxis = "")
}
\arguments{
\item{data}{Numeric matrix of dimension \eqn{n \times p}, representing
the observed multivariate time series \eqn{\{\mathbf{y}_t\}_{t=1}^n}.}

\item{muhats}{Optional numeric matrix of the same dimension as `data`,
giving the estimated fluctuating mean sequence
\eqn{\{\hat{\boldsymbol{\mu}}_t\}_{t=1}^n}.
If \code{NULL}, only raw data and detected change points are shown.}

\item{cps}{Numeric vector of detected change point locations.}

\item{titlename}{Character string for the plot title.}

\item{xaxis}{Character string for the x-axis label (e.g., "Time").}
}
\value{
A \pkg{ggplot2} object displaying the time series, estimated means
(if provided), and detected change points.
}
\description{
Visualizes multivariate time series data together with the estimated
fluctuating mean sequence and detected change points obtained from the
proposed change point detection (CPD) algorithm.
Each variable is plotted in a separate panel (facet), with vertical dashed
lines marking detected change points and solid curves showing the
estimated means when provided.
}
\details{
When \eqn{p = 1}, the function produces a single plot displaying the
observed time series, the estimated mean curve, and vertical dashed lines
indicating the detected change points. When \eqn{p > 1}, each variable is
shown in a separate facet with independently scaled y-axes for improved
readability. If \code{muhats} is provided, the estimated mean is overlaid
using \code{geom_line()}; otherwise, only the observed data and detected
change points are displayed.
}
