% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EW_ForLion_GLM_Optimal.R
\name{EW_ForLion_GLM_Optimal}
\alias{EW_ForLion_GLM_Optimal}
\title{EW ForLion for generalized linear models}
\usage{
EW_ForLion_GLM_Optimal(
  n.factor,
  factor.level,
  var_names = NULL,
  hfunc,
  h.prime = NULL,
  Integral_based,
  b_matrix,
  joint_Func_b,
  Lowerbounds,
  Upperbounds,
  xlist_fix = NULL,
  link,
  delta0 = 1e-05,
  epsilon = 1e-12,
  reltol = 1e-05,
  delta = 0,
  maxit = 100,
  random = FALSE,
  nram = 3,
  random.initial = FALSE,
  nram.initial = 3,
  logscale = FALSE,
  rowmax = NULL,
  Xini = NULL,
  pini = NULL
)
}
\arguments{
\item{n.factor}{vector of numbers of distinct levels, “0” indicating continuous factors that always come first, “2” or more for discrete factors, and “1” not allowed.}

\item{factor.level}{list of distinct factor levels, “(min, max)” for continuous factors that always come first, finite sets for discrete factors.}

\item{var_names}{Names for the design factors. Must have the same length asfactor.level. Defaults to "X1", "X2", ...}

\item{hfunc}{function for generating the corresponding model matrix or predictor vector, given an experimental setting or design point.}

\item{h.prime}{User-supplied derivative function for continuous factors x_(1) in R^k (k is the number of continuous variables). For MLMs: returns a list of J*p matrices dX_x/dx_j, j=1,...,k (numerical derivatives if omitted).  For GLMs: returns the p times k matrix dh(x)/dx_(1) (defaults to main effects if omitted).}

\item{Integral_based}{TRUE or FALSE, whether or not integral-based EW D-optimality is used, FALSE indicates sample-based EW D-optimality is used.}

\item{b_matrix}{matrix of bootstrapped or simulated parameter values.}

\item{joint_Func_b}{prior distribution function of model parameters}

\item{Lowerbounds}{vector of lower ends of ranges of prior distribution for model parameters.}

\item{Upperbounds}{vector of upper ends of ranges of prior distribution for model parameters.}

\item{xlist_fix}{list of discrete factor experimental settings under consideration, default NULL indicating a list of all possible discrete factor experimental settings will be used.}

\item{link}{link function, default "logit", other links: "probit", "cloglog", "loglog", "cauchit", "log", "identity"}

\item{delta0}{merging threshold for initial design, such that, || x_i(0) - x_j(0) || >= delta0, default 1e-5}

\item{epsilon}{tuning parameter as converging threshold, such that, a nonnegative number is regarded as numerical zero if less than epsilon, default 1e-12.}

\item{reltol}{the relative convergence tolerance, default value 1e-5}

\item{delta}{relative difference as merging threshold for the merging step, the distance of two points less than delta may be merged, default 0, can be different from delta0 for the initial design.}

\item{maxit}{the maximum number of iterations, default value 100}

\item{random}{TRUE or FALSE, if TRUE then the function will run lift-one with additional "nram" number of random approximate allocation, default to be FALSE}

\item{nram}{when random == TRUE, the function will run lift-one nram number of initial proportion p00, default is 3}

\item{random.initial}{TRUE or FALSE, whether or not to repeat the whole procedure multiple times with random initial designs, default FALSE.}

\item{nram.initial}{number of times repeating the whole procedure with random initial designs, valid only if random.initial is TRUE, default 3.}

\item{logscale}{TRUE or FALSE, whether or not to run the lift-one step in log-scale, i.e., using EW_liftoneDoptimal_log_GLM_func() or EW_liftoneDoptimal_GLM_func()}

\item{rowmax}{maximum number of points in the initial design, default NULL indicates no restriction}

\item{Xini}{initial list of design points, default NULL indicating automatically generating an initial list of design points.}

\item{pini}{A numeric vector specifying the initial weights for the design points in Xini, default NULL indicating automatically generating an uniform weights of design points.}
}
\value{
m             number of design points

x.factor      matrix with rows indicating design point

p             EW D-optimal approximate allocation

det           Optimal determinant of the expected Fisher information matrix

x.model       model matrix X

E_w           vector of E_w such that E_w=diag(p*E_w)

convergence   TRUE or FALSE

min.diff      the minimum Euclidean distance between design points

x.close       a pair of design points with minimum distance
}
\description{
EW ForLion algorithm to find EW D-optimal design for GLM models with mixed factors.
Reference Section 3 of Lin, Huang, Yang (2025).
Factors may include discrete factors with finite number of distinct levels and continuous factors
with specified interval range (min, max), continuous factors, if any, must serve as main-effects
only, allowing merging points that are close enough.Continuous factors first then discrete factors,
 model parameters should in the same order of factors.
}
\examples{
#Example Crystallography Experiment
hfunc.temp = function(y) {c(y,1)}   # y -> h(y)=(y1,1)
n.factor.temp = c(0)  # 1 continuous factors
factor.level.temp = list(c(-1,1))
link.temp="logit"
paras_lowerbound<-c(4,-3)
paras_upperbound<-c(10,3)
 gjoint_b<- function(x) {
 Func_b<-1/(prod(paras_upperbound-paras_lowerbound))
 ##the prior distributions are follow uniform distribution
return(Func_b)
}
EW_ForLion_GLM_Optimal(n.factor=n.factor.temp, factor.level=factor.level.temp,
hfunc=hfunc.temp,Integral_based=TRUE,joint_Func_b=gjoint_b, Lowerbounds=paras_lowerbound,
Upperbounds=paras_upperbound, link=link.temp, delta0=1e-5, epsilon=1e-5, reltol=1e-2,
delta=0.01,maxit=500, random=FALSE, nram=3, logscale=FALSE,Xini=NULL)
}
