% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py_deps.R
\name{ensure_py_env}
\alias{ensure_py_env}
\title{Ensure a Conda environment and Python dependencies for FuelDeep3D}
\usage{
ensure_py_env(
  envname = "pointnext",
  python_version = "3.10",
  reinstall = FALSE,
  cpu_only = TRUE,
  conda = NULL
)
}
\arguments{
\item{envname}{Character. Name of the Conda environment to use/create.}

\item{python_version}{Character. Python version used if a new env is created (e.g. "3.10").}

\item{reinstall}{Logical. If TRUE, forces dependency installation even if key modules are present.}

\item{cpu_only}{Logical. If TRUE, installs CPU-only PyTorch wheels. If FALSE, installs CUDA wheels (cu121).}

\item{conda}{Path to conda binary. Default uses \code{reticulate::conda_binary()}.}
}
\value{
Invisibly TRUE if environment was ensured + activated, FALSE if skipped during check.
}
\description{
Creates (if needed) and activates a Conda environment for FuelDeep3D, then
installs the required Python dependencies into that environment using pip via
\code{reticulate::conda_install(..., pip = TRUE)}.
}
\details{
This function is intentionally opt-in. It requires:
\itemize{
\item An existing Conda installation (Miniconda/Anaconda), discoverable by reticulate.
\item Internet connection to install Python packages.
}

For CRAN safety, this function will not run during \code{R CMD check}.
}
\examples{
\dontrun{
# Requires Conda + internet
ensure_py_env(envname = "pointnext", python_version = "3.10", cpu_only = TRUE)

# CUDA wheels (requires compatible NVIDIA drivers)
ensure_py_env(envname = "pointnext", python_version = "3.10", cpu_only = FALSE)

# Inspect reticulate Python
reticulate::py_config()
}

}
