% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{evaluate_two_las}
\alias{evaluate_two_las}
\title{Evaluate predictions stored in two LAS/LAZ objects}
\usage{
evaluate_two_las(
  truth_las,
  pred_las,
  truth_col = "label",
  pred_col = "Classification",
  classes = NULL,
  drop_na = TRUE,
  class_names = NULL,
  show_codes = TRUE
)
}
\arguments{
\item{truth_las}{A \code{lidR::LAS} containing ground-truth labels.}

\item{pred_las}{A \code{lidR::LAS} containing predicted labels.}

\item{truth_col}{Character. Name of the ground-truth label column (default \code{"label"}).}

\item{pred_col}{Character. Name of the prediction column (default \code{"Classification"}).}

\item{classes}{Optional integer vector of expected class IDs (e.g. \code{0:2}, \code{0:3}).
If \code{NULL}, inferred from observed truth and pred values.}

\item{drop_na}{Logical. If \code{TRUE} (default), rows with NA/Inf in truth or pred are dropped.}

\item{class_names}{Optional class name mapping. Either:
\itemize{
\item Named: \code{c("0"="Ground","1"="Branch","2"="Leaves")}
\item Unnamed length-K: \code{c("Ground","Branch","Leaves")} (must match \code{classes})
}}

\item{show_codes}{Logical. If \code{TRUE} (default), class labels display like \code{"0 (Ground)"}.}
}
\value{
A list containing the confusion matrix and metrics.
}
\description{
Computes the confusion matrix and metrics when ground truth and predictions come from
two separate \code{lidR::LAS} objects.
}
\details{
\strong{Important:} This assumes the LAS objects are point-wise aligned (with the same points and order).
If they are not aligned, metrics will be meaningless.
}
\examples{
if (requireNamespace("lidR", quietly = TRUE)){

library(lidR)
truth <-  readLAS(system.file("extdata", "las", "tree2.laz", package = "FuelDeep3D"))
pred  <- readLAS(system.file("extdata", "las", "tree21.laz", package = "FuelDeep3D"))

res <- evaluate_two_las(
  truth, pred,
  truth_col = "label",
  pred_col  = "Classification",
  classes   = 0:2,
  class_names = c("0"="Ground","1"="Branch","2"="Leaves")
)

res$class_accuracy
cat(sprintf("accuracy = \%.2f\%\%\n", 100 * res$accuracy))
}
}
