% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{las_class_distribution}
\alias{las_class_distribution}
\title{Class distribution summary for a LAS point cloud}
\usage{
las_class_distribution(
  las,
  field = "Classification",
  class_labels = NULL,
  include_na = TRUE,
  sort_by = c("n_points", "class", "percent"),
  decreasing = TRUE
)
}
\arguments{
\item{las}{A \code{LAS} object from \code{lidR}.}

\item{field}{Character. Column name in \code{las@data} containing class values
(e.g., \code{"Classification"}, \code{"label"}).}

\item{class_labels}{Optional. A named character vector mapping class values
to human-readable names, e.g. \code{c("0"="Ground","1"="Stem","2"="Crown")}.
Names must match the class values as characters.}

\item{include_na}{Logical. If \code{TRUE} (default), includes \code{NA} as a
separate row (shown as class \code{"<NA>"}). If \code{FALSE}, drops NA values.}

\item{sort_by}{Character. Sort rows by \code{"n_points"} (default),
\code{"class"}, or \code{"percent"}.}

\item{decreasing}{Logical. If \code{TRUE} (default), sorts descending.}
}
\value{
A \code{data.frame} with columns:
\describe{
\item{class}{Class value as character (NA shown as \code{"<NA>"})}
\item{name}{(Optional) human-readable name if \code{class_labels} provided}
\item{n_points}{Number of points in that class}
\item{percent}{Percent of total points in that class}
}
}
\description{
Computes how many points belong to each class value in a given LAS attribute
field (e.g., predicted classes stored in \code{Classification}, or original
labels stored in \code{label}). Returns a tidy \code{data.frame} with counts
and percentages.
}
\details{
This is useful after prediction to quickly inspect class balance and verify
that classes look reasonable (e.g., not all points predicted as one class).
}
\examples{
if (requireNamespace("lidR", quietly = TRUE)){
library(lidR)
las <-  readLAS(system.file("extdata", "las", "tree2.laz", package = "FuelDeep3D"))

# 1) Predicted distribution (common case)
las_class_distribution(las, field = "Classification")

# 2) Raw label distribution
las_class_distribution(las, field = "label")

# 3) With human-readable names
labs <- c("0"="Ground vegetation", "1"="Foliage", "2"="Branches")
las_class_distribution(las, field = "Classification", class_labels = labs)

# 4) Drop NA rows if you don't want them
las_class_distribution(las, field = "Classification", include_na = FALSE)
}

}
