% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_timeseries2.R
\name{plot_timeseries2}
\alias{plot_timeseries2}
\title{Time series plot of two variables in two different axes}
\usage{
plot_timeseries2(
  data,
  var,
  time,
  type = c("cov", "cov"),
  pop = NULL,
  pt = 1e+05,
  area = NULL,
  aggregate_space = NULL,
  aggregate_time = NULL,
  aggregate_space_fun = "mean",
  aggregate_time_fun = "mean",
  align = "min",
  title = NULL,
  var_label = NULL,
  legend = "Variable",
  ylab = NULL,
  xlab = NULL,
  free_y_scale = FALSE,
  palette = c("#168c81", "#B98AFB"),
  alpha = 0.9
)
}
\arguments{
\item{data}{Data frame containing equally spaced (daily, weekly, monthly)
covariate or disease case observations for one or multiple locations.}

\item{var}{A character vector of length 2 (left axis, right axis) identifying
the variables to be plotted.}

\item{time}{Name of the variable that identifies the temporal dimension
of the data frame. Its values must be in date format ("yyyy-mm-dd")
representing the day of observation for daily data, the first day of the
week for weekly, or the first day of the month for monthly observations.}

\item{type}{A character vector of length 2 (left axis, right axis) that
specifies the types of variable in \code{var}. Possible values include
'cov' (covariate, default), 'counts' (case counts), and 'inc' (case
incidence). If \code{type='inc'}, \code{pop} is required.}

\item{pop}{Character identifying the variable name for population. Only
needed if \code{type='inc'}.}

\item{pt}{Numerical only used for \code{type='inc'}. It represents the scale
of the person-time (default 100,000) for incidence rates.}

\item{area}{Name of variable that identifies the different locations
(e.g., areal units) for which a time series is available.}

\item{aggregate_space}{Name of variable used to define spatial aggregation
groups.}

\item{aggregate_time}{Temporal scale used to perform
temporal aggregation. Options are: "week" (ISO 8601), "month", "year".}

\item{aggregate_space_fun}{Character indicating the function to be used
in the aggregation over space for \code{type="cov"}. Options are "mean" (default),
"median", "sum". For case counts and incidence, "sum" is always applied.}

\item{aggregate_time_fun}{Character indicating the function to be used
in the aggregation over time for \code{type="cov"}. Options are "mean" (default),
"median", "sum". For case counts and incidence, "sum" is always applied.}

\item{align}{Options to align the two plots. Defaults to "min", which forces
the minimum of the two variables to be aligned. Other options include "mean"
and "median".}

\item{title}{Optional title of the plot.}

\item{var_label}{A character vector of length 2 (left axis, right axis) with
custom names for the case or covariate variable.}

\item{legend}{Character with a custom name for the legend.}

\item{ylab}{A character vector of length 2  (left, right) for the y-axes.}

\item{xlab}{Label for the x-axis.}

\item{free_y_scale}{Logical, default FALSE. Allows different scales in the
y_axis when facets are used.}

\item{palette}{A character vector of length 2 (left axis, right axis)
indicating the colours (R or hex codes) to use for each of the two
variables).}

\item{alpha}{Numerical between 0 and 1 determining the transparency of the
lines.}
}
\value{
A dual-axis ggplot2 time series plot.
}
\description{
Plots dual-axis time series of two covariates, case counts, or
incidence rates.
}
\examples{
# Load data
data("dengue_MS")
data("dengue_SP")

# Plotting two covariates with temporal aggregation, align using the mean
plot_timeseries2(dengue_SP,
                 var = c("temp_med", "precip_tot"),
                 time = "date",
                 align = "mean",
                 aggregate_time = "month")

# Plotting case incidence and a covariate with temporal aggregation
# and customized colours and labels
plot_timeseries2(dengue_SP,
                 var = c("cases", "precip_tot"),
                 type = c("inc", "cov"),
                 var_label = c("Incidence", "Precipitation"),
                 title = "Precipitation and dengue incidence in Sao Paulo",
                 time = "date",
                 pop = "pop",
                 aggregate_time = "month",
                 palette = c("darkgreen", "royalblue"),
                 alpha = 0.8)

# Plotting case incidence and a covariate with spatial aggregation
plot_timeseries2(dengue_MS,
                 var = c("dengue_cases", "pdsi"),
                 type = c("inc", "cov"),
                 pop = "population",
                 time = "date",
                 area = "micro_code",
                 aggregate_space = "meso_code")

}
\seealso{
\link{plot_timeseries} for single-axis time series plots.
}
