% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{asymp.var}
\alias{asymp.var}
\title{Asymptotic variance of model-averaged quantile estimates}
\usage{
asymp.var(mywt, covint, qqq = NULL, order = 2)
}
\arguments{
\item{mywt}{Weight computation result list from \code{weight.com()}.}

\item{covint}{Array (2 x 2 x numk) of interpolated covariance matrices.}

\item{qqq}{Numeric vector of quantile probabilities.}

\item{order}{Moving average order for smoothing. Default is 2.}
}
\value{
A list containing:
\describe{
  \item{fin.se.MA.qua}{SE under fixed weights for MA}
  \item{fin.se.bma.qua}{SE under fixed weights for BMA}
  \item{adj.se.MA.qua}{SE under random weights for MA}
  \item{adj.se.bma.qua}{SE under random weights for BMA}
  \item{MatC}{Cross-covariance array (numk x numk x numq)}
}
}
\description{
Internal function that computes asymptotic standard errors
for model-averaged quantile estimates under both fixed-weight and
random-weight assumptions.
}
\keyword{internal}
