% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_plots.R
\name{magev.rlplot}
\alias{magev.rlplot}
\title{Return Level Plot for MAGEV}
\usage{
magev.rlplot(par = NULL, se.vec = NULL, data = NULL)
}
\arguments{
\item{par}{A numeric vector of GEV parameters (mu, sigma, xi) in Hosking style.
Typically from \code{zx$surr$par} where \code{zx} is the output of
\code{\link{ma.gev}}.}

\item{se.vec}{A numeric vector of standard errors for the quantile estimates
corresponding to the plotting positions. Typically from \code{zx$ranw.se.ma}.}

\item{data}{A numeric vector of observed data (annual maxima).}
}
\value{
NULL. The function produces a plot as a side effect.
}
\description{
Displays fitted return levels with 95% confidence intervals against
return period on a log scale.
}
\details{
The plot shows:
\itemize{
  \item Black line: Fitted return level curve
  \item Blue lines: 95% confidence interval (mean +/- 1.96 * SE)
  \item Black points: Observed data at empirical return periods
}

The x-axis (return period) is on a log scale, ranging from 0.1 to 900 years.
}
\examples{
data(streamflow)
ff <- c(seq(0.01, 0.09, by = 0.01), 0.1, 0.2, 0.3, 0.4, 0.5,
        0.6, 0.7, 0.8, 0.9, 0.93, 0.95, 0.98, 0.99,
        0.993, 0.995, 0.998, 0.999)
zx <- ma.gev(streamflow$r1, quant = ff, weight = 'like1',
             numk = 9, varcom = TRUE)
magev.rlplot(par = zx$surr$par, se.vec = zx$ranw.se.ma, data = streamflow$r1)

}
\references{
Shin, Y., Shin, Y., & Park, J. S. (2026). Model averaging with mixed criteria
for estimating high quantiles of extreme values: Application to heavy rainfall.
\emph{Stochastic Environmental Research and Risk Assessment}, 40(2), 47.
\doi{10.1007/s00477-025-03167-x}
}
\seealso{
\code{\link{ma.gev}} for the main model averaging function,
  \code{\link{magev.qqplot}} for Q-Q diagnostic plots.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
