% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{movave}
\alias{movave}
\title{Moving average smoother for quantiles and weights}
\usage{
movave(order, numk, numq, zp, wt = NULL)
}
\arguments{
\item{order}{Order of the moving average.}

\item{numk}{Number of candidate submodels.}

\item{numq}{Number of quantile probabilities.}

\item{zp}{Matrix (numq x numk) of quantile estimates.}

\item{wt}{Numeric vector of weights (length numk).}
}
\value{
A list containing:
\describe{
  \item{ez}{Matrix (numq x numk) of smoothed quantile estimates}
  \item{ew}{Numeric vector of smoothed weights}
}
}
\description{
Internal function that applies moving average smoothing
to quantile estimates and weights across candidate submodels.
}
\keyword{internal}
