% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{pargev.xifix}
\alias{pargev.xifix}
\title{GEV parameter estimation with fixed shape parameter (MAGEV internal)}
\usage{
pargev.xifix(lmom, xifix = 0.1, checklmom = TRUE, ...)
}
\arguments{
\item{lmom}{L-moments object from \code{lmomco::lmoms()}.}

\item{xifix}{Fixed shape parameter value. Default is 0.1.}

\item{checklmom}{Logical. Whether to check L-moment validity. Default is TRUE.}

\item{...}{Additional arguments (unused).}
}
\value{
A list with components:
\describe{
  \item{type}{Character "gev"}
  \item{para}{Numeric vector of GEV parameters (mu, sigma, xi)}
  \item{source}{Character "pargev"}
}
}
\description{
Internal function that estimates GEV location and scale
parameters given a fixed shape parameter, using L-moment equations.
}
\keyword{internal}
