em_short <-
function(x, k, max_iter = 3, tol = 1e-6) {
  
  # k = 7 
  N <- nrow(x)  
  P <- ncol(x)
  sigma <- array(0, dim = c(P, P, k))  
  x <-  data.frame(x)
  K <- k
  P <- ncol(x)
  
  # inital value from kmean 
  kmeans_init <- suppressWarnings(kmeans(x,k,iter.max = 1))
  
  pi_k <- kmeans_init$size/sum(kmeans_init$size)
  mu <- kmeans_init$centers
  
  rownames(x) <- NULL
  X_cluster <- split(x, kmeans_init$cluster) 
  
  
  
  for (i in 1:K) {
    X_centered <- sweep(X_cluster[[i]], 2, mu[i,])
    X_centered <- as.matrix(X_centered) 
    sigma[ , ,i] <- (t(X_centered) %*% X_centered) / nrow(X_cluster[[i]])
    
  }
  
  
  log_likelihood_old <- 0
  
  
  gamma <- matrix(NA, N, K)
  
  for (iter in 1:max_iter) {
    
    for (i in 1:k) {
      gamma[, i] <- pi_k[i] * safe_dmv(as.matrix(x), mu = mu[i,], sigma = sigma[,,i])
    }
    gamma <- gamma / rowSums(gamma)  
    
    
    Nk <- colSums(gamma)  
    pi_k <- Nk / N  
    
    for (i in 1:k) {
      mu[i, ] <- colSums(gamma[, i] * x) / Nk[i] 
      centered_data <- sweep(as.matrix(x), 2, mu[i, ])
      sigma[,,i] <- t(centered_data) %*% (gamma[, i] * centered_data) / Nk[i]  
    }
    
    
    log_likelihood_new <- sum(log(rowSums(gamma)))
    
    
    if (abs(log_likelihood_new - log_likelihood_old) < tol) {
      
      break
    }
    
    log_likelihood_old <- log_likelihood_new
  }
  
  
  partition_vector <- apply(gamma, 1, which.max)
  
  
  return(list(mu = mu, sigma = sigma, pi_k = pi_k, gamma = gamma,
              partition = partition_vector, ll = log_likelihood_new))
}
