% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinning_algorithm.R
\name{select_target_points}
\alias{select_target_points}
\title{Select Target Number of Points for Spatial Thinning}
\usage{
select_target_points(
  distance_matrix,
  target_points,
  thin_dist,
  trials,
  all_trials = FALSE
)
}
\arguments{
\item{distance_matrix}{A matrix of pairwise distances between points.}

\item{target_points}{An integer specifying the number of points to retain.}

\item{thin_dist}{A positive numeric value representing the thinning distance in kilometers.}

\item{trials}{A positive integer specifying the number of thinning trials to perform. Default is 10.}

\item{all_trials}{A logical value indicating whether to return results of all attempts (`TRUE`) or only the best attempt with the most points retained (`FALSE`). Default is `FALSE`.}
}
\value{
A list of logical vectors indicating which points are kept in each trial if `all_trials` is `TRUE`; otherwise, a list with a single logical vector indicating the points kept in the best trial.
}
\description{
This function selects a specified number of points from a spatial dataset while maximizing
the distance between selected points.
}
\examples{
# Example distance matrix (3 points)
dist_matrix <- matrix(c(0, 2, 5,
                        2, 0, 3,
                        5, 3, 0), ncol = 3)

# Select 2 points maximizing distance
result <- select_target_points(dist_matrix, target_points = 2,
                              thin_dist = 4, trials = 5, all_trials = TRUE)

}
