% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_fonc.R
\name{NPFSS}
\alias{NPFSS}
\title{NPFSS scan procedure (univariate functional or multivariate functional)}
\usage{
NPFSS(
  data,
  MC = 999,
  typeI = 0.05,
  nbCPU = 1,
  variable_names = NULL,
  times = NULL,
  initialization,
  permutations
)
}
\arguments{
\item{data}{list of numeric matrices or a matrix. List of nb_sites (or nb_individuals if the observations are by individuals and not by site) matrices of the data, the rows correspond to the variables and each column represents an observation time (multivariate case) ; or Matrix of the data, the rows correspond to the sites (or to the individuals) and each column represents an observation time (univariate case). The times must be equally spaced and the same for each site/individual.}

\item{MC}{numeric. Number of Monte-Carlo permutations to evaluate the statistical significance of the clusters. By default: 999.}

\item{typeI}{numeric. The desired type I error. A cluster will be evaluated as significant if its associated p-value is less than typeI. By default 0.05.}

\item{nbCPU}{numeric. Number of CPU. If nbCPU > 1 parallelization is done. By default: 1.}

\item{variable_names}{character. Names of the variables. By default NULL. Ignored if the data is a matrix (univariate functional case).}

\item{times}{numeric. Times of observation of the data. By default NULL.}

\item{initialization}{list. Initialization for the scan procedure (see \code{\link{InitScan}} for more details).}

\item{permutations}{matrix. Indices of permutations of the data.}
}
\value{
An object of class ResScanOutputUniFunct or ResScanOutputMultiFunct depending on the data
}
\description{
This function computes the NPFSS (Nonparametric Functional scan statistic for multivariate or univariate functional data).
}
\references{
Zaineb Smida and Lionel Cucala and Ali Gannoun and Ghislain Durif (2022). A Wilcoxon-Mann-Whitney spatial scan statistic for functional data. Computational Statistics & Data Analysis, 167.
}
