% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HNPclassifier.r
\name{hnp_umbrella}
\alias{hnp_umbrella}
\title{HNP Umbrella Algorithm}
\usage{
hnp_umbrella(
  S,
  levels,
  tolerances,
  A1 = NULL,
  method = "randomforest",
  hnp_split = NULL,
  class_col
)
}
\arguments{
\item{S}{Training dataset}

\item{levels}{Confidence levels (alpha) for each class}

\item{tolerances}{Tolerance parameters (delta) for each class}

\item{A1}{Candidate thresholds for class 1}

\item{method}{Classification method to use ('randomforest', 'svm', 'logistic')}

\item{hnp_split}{Data splitting ratios for each class}

\item{class_col}{Character scalar. Name of the class column in the dataset
(must be mapped to levels "1","2","3").}
}
\value{
A classifier function that takes new data and classifies it into a class with controlled
type-one error rate
}
\description{
Implementation of the HNP Umbrella algorithm for ternary classification
}
\examples{
set.seed(123)
n <- 500
features <- data.frame(
  x1 = rnorm(n),
  x2 = rnorm(n)
)
y <- factor(sample(c("1", "2", "3"), n, replace = TRUE, prob = c(0.2, 0.3, 0.5)))
data <- cbind(features, y)
clf <- hnp_umbrella(
  S = data,
  levels = c(0.1, 0.1),
  tolerances = c(0.1, 0.1),
  class_col = "y",
  method = "randomforest"
)
}
\references{
Lijia Wang, Y. X. Rachel Wang, Jingyi Jessica Li, and Xin Tong (2024).
"Hierarchical Neyman-Pearson Classification for Prioritizing Severe Disease
Categories in COVID-19 Patient Data."
\emph{Journal of the American Statistical Association}, 119(545), 39-51.
\doi{10.1080/01621459.2023.2270657}
}
