% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_confidence_limit_values.R
\name{calculate_confidence_limit_values}
\alias{calculate_confidence_limit_values}
\title{Calculate the value of confidence limit}
\usage{
calculate_confidence_limit_values(
  diff_uptake_dat,
  confidence_level = 0.98,
  theoretical = FALSE,
  fractional = TRUE,
  n_rep = NULL
)
}
\arguments{
\item{diff_uptake_dat}{differential data calculated using 
calculate_diff_uptake function}

\item{confidence_level}{confidence level for the test, from range [0, 1]}

\item{theoretical}{\code{logical}, determines if values are theoretical}

\item{fractional}{\code{logical}, determines if values are fractional}

\item{n_rep}{number of replicates}
}
\value{
range of confidence limit interval
}
\description{
Calculates confidence limit values for prepared provided, 
based on chosen parameters.
}
\details{
Function \code{\link{calculate_confidence_limit_values}} 
calculates confidence limit using Houde test. The confidence limits 
are calculated on whole provided dataset. If the user wishes to calculate
confidence limit for one, two or more time points, the provided data 
should be adjusted accordingly.
}
\examples{
diff_uptake_dat <- calculate_diff_uptake(alpha_dat)
calculate_confidence_limit_values(diff_uptake_dat)
                              
}
\references{
Houde, D., Berkowitz, S.A., and Engen, J.R. (2011). 
The Utility of Hydrogen/Deuterium Exchange Mass Spectrometry in 
Biopharmaceutical Comparability Studies. J Pharm Sci 100, 2071–2086.
}
\seealso{
\code{\link{read_hdx}} 
\code{\link{calculate_diff_uptake}} 
\code{\link{create_diff_uptake_dataset}}
}
