% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_diff_uptake.R
\name{calculate_diff_uptake}
\alias{calculate_diff_uptake}
\title{Calculate differential uptake}
\usage{
calculate_diff_uptake(
  dat,
  protein = unique(dat[["Protein"]][1]),
  states = unique(dat[["State"]])[1:2],
  time_0 = min(dat[["Exposure"]]),
  time_t = unique(dat[["Exposure"]])[3],
  time_100 = max(dat[["Exposure"]]),
  deut_part = 0.9
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function}

\item{protein}{chosen protein}

\item{states}{vector of two states for chosen protein. Order is important, as the 
deuterium uptake difference is calculated as state_1 - state_2}

\item{time_0}{minimal exchange control time point of measurement [min]}

\item{time_t}{time point of the measurement for which the calculations
are done [min]}

\item{time_100}{maximal exchange control time point of measurement [min]}

\item{deut_part}{deuterium percentage in solution used in experiment, 
value from range [0, 1]}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculates differential deuterium uptake between 
two selected biological states.
}
\details{
Function \code{\link{calculate_diff_uptake}} calculates
differential values based on provided criteria for peptides for chosen
protein in selected states. The methods of calculation of deuterium uptake
difference, fractional deuterium uptake difference with respect to 
minimal/maximal exchange controls or theoretical tabular values are
thoroughly described in the `Data processing` article, as well as 
law of propagation of uncertainty, used to calculate uncertainty.
}
\examples{
diff_dat <- calculate_diff_uptake(alpha_dat)
head(diff_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_state_uptake}}
}
