% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fst_HapDip.R
\name{pairwise.fst}
\alias{pairwise.fst}
\title{Compute pairwise Fst for all population pairs}
\usage{
pairwise.fst(allele.freq.table, verbose = TRUE)
}
\arguments{
\item{allele.freq.table}{A [data.table::data.table] produced by
[allele.freq.WS()], containing at minimum the columns \code{Pop},
\code{Contig}, \code{Window_starts}, \code{Window_ends}, \code{N_sites},
and \code{Freq.A}.}

\item{verbose}{Logical. If `TRUE` (default), print progress messages.}
}
\value{
A [data.table::data.table] with one row per population-pair-contig-
  window combination and the following columns:
  \describe{
    \item{Contig}{Contig (chromosome) name.}
    \item{window_lims}{A character string of the form
      \code{"Window_starts - Window_ends"} identifying the window.}
    \item{Sum.Sites}{Total number of called genotype entries summed across
      both populations in the window.}
    \item{Mean.p}{Mean reference allele frequency across the two
      populations in the window.}
    \item{Var.p}{Population variance of the reference allele frequency
      across the two populations in the window.}
    \item{Fst}{Estimated Fst for the window.}
    \item{Pop_pair}{A character string of the form \code{"Pop1 - Pop2"}
      identifying the population pair.}
  }
}
\description{
Takes the per-window allele frequency table produced by [allele.freq.WS()]
and computes Wright's Fst for every unique pair of populations. Within each
contig-window, Fst is estimated as the ratio of the among-population
variance in reference allele frequency to its expected maximum under
panmixia:
\code{Fst = Var(p) / (mean(p) * (1 - mean(p)))}.
Windows in which the mean reference allele frequency is 0 or 1 (i.e.
monomorphic across the pair) are set to 0.
}
\examples{
vcf_path <- system.file("extdata",
                        "example.vcf",
                        package = "HaploDiploidEquilibrium")
result   <- vcf2GT(vcf_path)
gt       <- result$gt_matrix
contigs  <- result$contig_vector
pos      <- result$positions

pop.file <- data.frame(ID  = colnames(gt),
                       Pop = c("PopA","PopA","PopB","PopB","PopB"))

af <- allele.freq.WS(geno.data  = gt,
                     pop.file   = pop.file,
                     contigs    = contigs,
                     positions  = pos,
                     window.size = 10000)
fst <- pairwise.fst(af)

}
\seealso{
[allele.freq.WS()] for computing the input allele frequency table,
  and [summarize_fst()] for computing weighted genome-wide summary
  statistics from the output.
}
