% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRGplot.R
\name{MRGplot}
\alias{MRGplot}
\title{Convenience function based on ggplot2 to plot multi-resolution grids with some
default suggestions For full flexibility it is better to use 
ggplot2 directly.The function can also be used for ordinary grids}
\usage{
MRGplot(
  himg,
  var,
  linecolor,
  option = "D",
  lwd = 0,
  lwdb = 1,
  borders,
  name = waiver(),
  title = NULL,
  xlim,
  ylim,
  crs,
  clip = TRUE,
  limits = NULL,
  transform = "identity",
  show.legend = TRUE
)
}
\arguments{
\item{himg}{A multi-resolution grid, typically resulting from a call to multiResGrid}

\item{var}{Which variable to plot}

\item{linecolor}{Which column or color to use for lines between grid cells. The default is not to plot lines}

\item{option}{The color map option to use, see \code{\link[viridis]{scale_color_viridis}} for more details}

\item{lwd}{Line width for the grid cells. Default is zero, to remove or minimize (for pdf) the line width}

\item{lwdb}{The line width for the border}

\item{borders}{A polygon object with borders than can be drawn on top of the multi-resolution grid. The 
object will also be used to clip the grid if \code{clip = TRUE}.}

\item{name}{Name to be used for color scale. The default is to use the name of the fill/color column. 
\code{name = NULL} will give no name.}

\item{title}{The title of the plot}

\item{xlim}{The limits for the x-axis. The default is to use the bounding box of the grid.}

\item{ylim}{The limits for the y-axis. The default is to use the bounding box of the grid.}

\item{crs}{The coordinate reference system (CRS) into which all data should be projected before plotting. 
If not specified, will use the CRS defined in the first sf layer of the plot.}

\item{clip}{Logical; should the grid be clipped to the borders object (if exsisting)?}

\item{limits}{Either \code{NULL} to use the default scale range or a numeric vector of 
length two providing limits of the scale. Use NA to refer to the existing minimum or maximum. See
\code{\link[ggplot2]{continuous_scale}} for more details}

\item{transform}{Possible transformation of the color scale, typical values can be  \code{"log"},
\code{"log10"} or \code{"sqrt"}, based on available transformations in the 
\code{scales} package. See for example \code{\link[scales]{transform_log}} and other transformations for
    more details.}

\item{show.legend}{Logical; should the legend be shown or not.}
}
\value{
The function will plot the object, and also return a valid 
\code{\link[ggplot2]{ggplot}}-object that 
can be further customized.
}
\description{
Convenience function based on ggplot2 to plot multi-resolution grids with some
default suggestions For full flexibility it is better to use 
ggplot2 directly.The function can also be used for ordinary grids
}
\details{
The function is a wrapper around ggplot, possibly calling \code{geom_sf} twice,
for the grid itself and for the borders. The function uses the 
\code{\link[viridis]{scale_color_viridis}} color scale.
}
\examples{

\donttest{
library(sf)
library(ggplot2)
library(dplyr)

if (require(giscoR)) {
  useBorder = TRUE 
} else {
  useBorder = FALSE
  print("You need to install giscoR for plotting borders and clipping the gridded maps")
}
# These are SYNTHETIC agricultural FSS data 
data(ifs_dk) # Census data

# Create spatial data
ifg = fssgeo(ifs_dk, locAdj = "LL")

if (useBorder) {
# Read country borders, only used for plotting, remove oversea regions
  borders = gisco_get_nuts(nuts_level = 0)
}

ress = c(1,5,10,20,40, 80, 160)*1000
# Gridding Utilized agricultural area (UAA)
ifl = gridData(ifg, "UAA",res = ress)

# Create a multi-resolution grid of UAA
himg1 = multiResGrid(ifl, vars = "UAA", ifg = ifg)

if (useBorder) {
  p1 = MRGplot(himg1, UAA, transform = "log10", borders = borders, clip = TRUE)
} else {
  p1 = MRGplot(himg1, UAA, transform = "log10")
}
p1

# Plot can be customized further (reverting to ggplot default color scale in this case)
p1 + scale_color_continuous() + scale_fill_continuous()

}


}
