% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formMWRcens.R
\name{formMWRcens}
\alias{formMWRcens}
\title{Format censored data}
\usage{
formMWRcens(censdat)
}
\arguments{
\item{censdat}{input data frame}
}
\value{
A formatted data frame of the censored data
}
\description{
Format censored data
}
\details{
This function is used internally within \code{\link{readMWRcens}} to format the input data for downstream analysis.  The formatting includes:

\itemize{
\item Convert Parameter: All parameters are converted to \code{Simple Parameter} in \code{\link{paramsMWR}} as needed,
\item Convert Missed and Censored Records: All values are converted to numeric
}
}
\examples{
library(dplyr)

censpth <- system.file('extdata/ExampleCensored.xlsx', 
     package = 'MassWateR')

censdat <- suppressMessages(readxl::read_excel(censpth, 
      na = c('NA', 'na', '')
    )) 
    
formMWRcens(censdat)
}
