\name{Update_column_clusters}
\alias{Update_column_clusters}
\title{
Update Column Cluster Assignments in REMAXINT and E-ReMI clustering framework. 
}
\description{
Updates column cluster assignments (C matrix) and corresponding G matrix in a two-mode clustering model based on a likelihood maximization procedure.
}
\usage{
Update_column_clusters(DC, I, J, initR, initC, initG, Q)
}
\arguments{
  \item{DC}{
  A numeric data matrix of size \code{I x J}, typically doubly centered, representing the two-mode data to be analyzed.
  }
  \item{I}{
  The number of rows (first mode entities) in the data matrix.
  }
  \item{J}{
  The number of columns (second mode entities) in the data matrix.
  }
  \item{initR}{
  Initial binary row-cluster assignment matrix of size \code{I x P}.
  }
  \item{initC}{
  Initial binary column-cluster assignment matrix of size \code{J x Q}.
  }
  \item{initG}{
  Initial cluster interaction matrix of size \code{P x Q}.
  }
  \item{Q}{
  The number of column clusters.
  }
}
\details{
This function updates the column cluster assignments by iteratively testing all possible cluster configurations for each column and selecting the one that maximizes the log-likelihood. 
After reassigning the clusters, it checks for empty clusters and reassigns the least likely columns to ensure all clusters are non-empty. The function then updates the G matrix accordingly.
}
\value{
A list with the following components:
  \item{C}{The updated column cluster assignment matrix of size \code{J x Q}.}
  \item{G}{The updated cluster interaction matrix of size \code{P x Q}.}
}
\references{
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2025). Robustness study of normality-based likelihood ratio tests 
for testing maximal interaction two-mode clustering and a permutation based alternative. \emph{Available on OSF} 
(submitted to Advances in Data Analysis and Classification).
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2023). E-ReMI: extended maximal interaction two-mode clustering. 
\emph{Journal of Classification, 40,  298-331}
Ahmed, Z., van Breukelen, G. J. P., Schepers, J., & Cassese, A. (2021). REMAXINT: a two-mode clustering-based method for statistical
inference on two-way interaction. \emph{Advances in Data Analysis and Classification, 15(4), 987-1013}
}
\author{
Zaheer Ahmed (ahmed@ifado.de), 
Jan Schepers (jan.schepers@maastrichtuniversity.nl), 
Uwe Ligges (ligges@statistik.tu-dortmund.de), 
Alberto Cassese (alberto.cassese@unifi.it), 
Gerard van Breukelen (gerard.vbreukelen@maastrichtuniversity.nl), 
Katja Ickstadt (ickstadt@statistik.tu-dortmund.de), 
Edmund Wascher (wascher@ifado.de)
}
\note{
This function assumes that the input cluster assignment matrices are binary and mutually exclusive for each item (i.e., hard clustering).
}
\seealso{
\code{\link{REMAXINT}}, \code{\link{E_ReMI}}, \code{\link[pracma]{pinv}}
}
\examples{
I <- 10
P <- 4
J <- 5 
Q <- 2
Nruns <- 5
DC <- matrix(rnorm(I * J), I, J)
initR <- diag(1, nrow = I, ncol = P)
initC <- diag(1, nrow = J, ncol = Q)
R_inv <- pracma::pinv(t(initR) \%*\% initR)
C_inv <- pracma::pinv(t(initC) \%*\% initC)
initG <- R_inv \%*\% t(initR) \%*\% DC \%*\% initC \%*\% C_inv
initG <- as.matrix(initG)
result <- Update_column_clusters(DC, I, J, initR, initC, initG, Q)
result
}
\keyword{column clustering in REMAXINT and E-REMI}
