% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStorage.R
\name{createStorage}
\alias{createStorage}
\title{Build a structure representing amino acid categories.}
\usage{
createStorage(categories)
}
\arguments{
\item{categories}{A character string. Similar to the \code{categories}
parameter of \code{\link{getEntropySignature}}.}
}
\value{
A list with one element (\code{character} vector) for amino acid
category and an element (empty named \code{numeric} vector) to be
loaded with the frequency in the metagenome of each amino acid category.
}
\description{
The function is used internally by \code{\link{fillPosition}}, which in
turn is an auxiliary function of \code{\link{getEntropySignature}}.
It creates a list with one element for each amino acid category, named
according to the categories used (e.g., "aliphatic", "aromatic", etc.).
Each element contains a set of amino acids identified by one-letter codes.
The list also includes an element containing an empty numeric vector, whose
names correspond to the labels of each category.
This vector is to be populated with the frequency of each category at a
given genomic position, by the \code{fillPosition} function.
}
\seealso{
\code{\link{getEntropySignature}}.
}
\keyword{internal}
