% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breeding.intern7.R
\name{breeding.intern7}
\alias{breeding.intern7}
\title{Internal function to simulate one meiosis}
\usage{
breeding.intern7(
  info.parent,
  parent,
  population,
  mutation.rate = 10^-5,
  remutation.rate = 10^-5,
  recombination.rate = 1,
  recom.f.indicator = NULL,
  duplication.rate = 0,
  duplication.length = 0.01,
  duplication.recombination = 1,
  delete.same.origin = FALSE,
  gene.editing = FALSE,
  nr.edits = 0,
  gen.architecture = 0,
  decodeOriginsU = MoBPS::decodeOriginsR,
  recombination.function = MoBPS::recombination.function.haldane,
  dup_activ = TRUE,
  rt_activ = TRUE,
  grandsib_activ = TRUE
)
}
\arguments{
\item{info.parent}{position of the parent in the dataset}

\item{parent}{list of information regarding the parent}

\item{population}{Population list}

\item{mutation.rate}{Mutation rate in each marker (default: 10^-5)}

\item{remutation.rate}{Remutation rate in each marker (default: 10^-5)}

\item{recombination.rate}{Average number of recombination per 1 length unit (default: 1M)}

\item{recom.f.indicator}{Use step function for recombination map (transform snp.positions if possible instead)}

\item{duplication.rate}{Share of recombination points with a duplication (default: 0 - DEACTIVATED)}

\item{duplication.length}{Average length of a duplication (Exponentially distributed)}

\item{duplication.recombination}{Average number of recombinations per 1 length uit of duplication (default: 1)}

\item{delete.same.origin}{If TRUE delete recombination points when genetic origin of adjacent segments is the same}

\item{gene.editing}{If TRUE perform gene editing on newly generated individual}

\item{nr.edits}{Number of edits to perform per individual}

\item{gen.architecture}{Used underlying genetic architecture (genome length in M)}

\item{decodeOriginsU}{Used function for the decoding of genetic origins [[5]]/[[6]]}

\item{recombination.function}{Function used to calculate position of recombination events (default: MoBPS::recombination.function.haldane())}

\item{dup_activ}{Internal parameter to check if duplications have to be simulated}

\item{rt_activ}{Internal parameter to check if RTs have to be simulated}

\item{grandsib_activ}{Internal parameter to check if grandsibling contributions have to be calculated}
}
\value{
Inherited parent gamete
}
\description{
Internal function to simulate one meiosis
}
\examples{
data(ex_pop)
child_gamete <- breeding.intern7(info.parent = c(1,1,1), parent = ex_pop$breeding[[1]][[1]][[1]],
                                population = ex_pop)
}
