#' @title Specifies the Factor Correlation Matrix for a Model
#' @description
#' This function generates a symmetric factor correlation matrix for a Structural Equation Model. The correlations must be provided as a vector of values between -1 and +1.
#' The vector can be entered in either row-wise or column-wise order, but the correlations must be supplied in the correct sequence.
#' If the model includes only a single factor, the function should be called as: "fcors.value(nf = 1, cors = c(1))"
#'
#' @author Fatih Orcan
#' @param nf An integer specifying the number of factors.
#' @param cors A numeric vector of correlations among the factors. Values must be between -1 and +1.
#' @return The function returns the factor correlation matrix.
#' @export
#' @examples
#' # This example represents a three-factor CFA model
#' #
#' fcors.value(nf=3, cors=c(1,.5,.6,.5,1,.4,.6,.4,1))

fcors.value <-function(nf, cors){
  if(nf==1){fcors<-matrix(1,1,1)}
  if(any(cors > 1) | any(cors < -1 )){stop("Values of the correlation should be between -1 and +1.
                                           Please re-run the function.")}
  if(nf>1){fcors<-matrix(ncol = nf, cors)}
  return(fcors)
}
