% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{EVSKGenHyp}
\alias{EVSKGenHyp}
\title{EVSK multivariate Generalized hyperbolic}
\usage{
EVSKGenHyp(lambda, chi, psi, mu, sigma, gamma)
}
\arguments{
\item{lambda}{scalar valued}

\item{chi}{scalar valued}

\item{psi}{scalar valued}

\item{mu}{a vector of dimension d}

\item{sigma}{a dxd covariance matrix}

\item{gamma}{a scalar value}
}
\value{
A list of theoretical values for the mean,   variance, skewness and
kurtosis vectors
}
\description{
Computes the theoretical values of the mean,  variance,
skewness and (excess) kurtosis vectors for the d-variate Generalized
Hyperbolic distribution \eqn{\mathcal{GH}\left( \lambda
,\chi ,\psi ,\boldsymbol{\mu },\boldsymbol{\Sigma },\boldsymbol{\gamma }%
\right)}
defined as
 \deqn{\mathbf{X}=\boldsymbol{\mu }+V\boldsymbol{\gamma }+\sqrt{V}\boldsymbol{%
\Sigma }^{1/2}\mathbf{Z}}
where \eqn{\mathbf{Z}\in \mathcal{N}\left( 0,\mathbf{I}_{d}\right)},
\eqn{ V \geq 0}, is independent of \eqn{\mathbf{Z}}, is a non-negative,
scalar-valued variate, which is \emph{Generalized Inverse Gaussian} (scalar
 valued GIG), \eqn{V\in GIG\left( \lambda ,\chi ,\psi \right)}.
}
\examples{
lambda <- 1
chi <- 2
psi <- 2
mu <- rep(0,2)
sigma <- diag(2)
gamma <-  c(0.2,0.5)
EVSKGenHyp(lambda, chi, psi, mu, sigma, gamma)
}
\references{
A.J. McNeil, R. Frey, and P. Embrechts.
Quantitative risk management: concepts,
techniques and tools-revised edition. Princeton university press, 2015.
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKSkewt}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumCFUSN}()},
\code{\link{MomCumGenHyp}()},
\code{\link{MomCumMVt}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
