% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sNUE.R
\name{sNUE}
\alias{sNUE}
\title{Calculate NUE of a System (sNUE)}
\usage{
sNUE(YieldN, Nloss)
}
\arguments{
\item{YieldN}{Observed crop yield N.}

\item{Nloss}{N lost from the system.}
}
\value{
A numeric vector of sNUE values.
}
\description{
The fraction of system N outputs that are captured as N yield.
Formula: sNUE = YieldN / (YieldN + Nloss)
}
\examples{
YieldN <- c(80, 90, 100)
Nloss <- c(20, 25, 20)
sNUE(YieldN, Nloss)
}
