% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OVL.GPQ.mix.R
\name{OVL.GPQ.mix}
\alias{OVL.GPQ.mix}
\title{GPQ-Mix}
\usage{
OVL.GPQ.mix(x, y, alpha = 0.05, interv = c(0, 20), k = 1000, all_mix = FALSE)
}
\arguments{
\item{x}{Numeric vector. Data from the first group. When \code{all_mix = FALSE}, this group
is modeled as Gaussian.}

\item{y}{Numeric vector. Data from the second group, modeled as a two-component Gaussian mixture.}

\item{alpha}{confidence level.}

\item{interv}{Numeric vector of length 2. Search interval for intersection points between the
corresponding densities.}

\item{k}{Number of simulated generalized pivotal quantities.}

\item{all_mix}{Logical. If \code{TRUE}, both groups are modeled as two-component Gaussian mixtures.
If \code{FALSE}, only \code{y} is modeled as a mixture and \code{x} is Gaussian.}
}
\value{
confidence interval.
}
\description{
Computes a confidence interval for the OVL between two populations under Gaussian and two-component Gaussian mixture models, or both
populations modeled as two-component Gaussian mixtures, using generalized inference.
}
\examples{
set.seed(1)
x <- ifelse(runif(100) < 0.5,
            rnorm(100, mean = 0, sd = 1),
            rnorm(100, mean = 2, sd = 1))
y <- ifelse(runif(100) < 0.5,
            rnorm(100, mean = 2.5, sd = 1),
            rnorm(100, mean = 2, sd = 1))
res <- OVL.GPQ.mix(x, y, all_mix = TRUE, interv = c(-10, 10))
res$IC1
res$IC2
}
