% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Orangutan.R
\name{run_orangutan}
\alias{run_orangutan}
\title{Run Orangutan}
\usage{
run_orangutan(
  data_path,
  output_dir = file.path(dirname(data_path), "analysis_outputs"),
  apply_allometry = FALSE,
  allometry_var = NULL,
  remove_outliers = FALSE,
  outlier_vars = NULL,
  outlier_tail_pct = 0.05,
  palette_name = "Paired",
  species_to_encircle = character(0),
  seeds = list(betadisper = 123, permanova = 456),
  point_aes = list(point_size = 3.5, jitter_width = 0.1, jitter_alpha = 0.8, jitter_shape
    = 21, jitter_color = "black", jitter_stroke = 0.35),
  mean_aes = list(size = 1.8, shape = 21, fill = "white", color = "black", stroke = 0.6),
  violin_aes = list(alpha = 0.4),
  box_aes = list(alpha = 0.4, width = 0.15),
  label_aes = list(text_size = 6, axis_text_size = 10, title_size = 12, label_offset =
    0.05),
  label_templates = NULL,
  verbose = FALSE
)
}
\arguments{
\item{data_path}{Path to input CSV file}

\item{output_dir}{Output directory for results}

\item{apply_allometry}{Logical; apply allometric correction}

\item{allometry_var}{Character; size variable for allometry}

\item{remove_outliers}{Logical; remove outliers}

\item{outlier_vars}{Variables used for outlier detection}

\item{outlier_tail_pct}{Tail proportion for Tukey filtering}

\item{palette_name}{RColorBrewer palette name}

\item{species_to_encircle}{Species to encircle in multivariate plots}

\item{seeds}{A named list of integer seeds for reproducibility, with elements:
\code{betadisper} for beta-dispersion permutation tests and
\code{permanova} for PERMANOVA permutation tests.
Defaults to \code{list(betadisper = 123, permanova = 456)}.}

\item{point_aes}{List of point aesthetics}

\item{mean_aes}{List of mean-point aesthetics}

\item{violin_aes}{List of violin aesthetics}

\item{box_aes}{List of boxplot aesthetics}

\item{label_aes}{List of label/text aesthetics}

\item{label_templates}{Optional plot label templates}

\item{verbose}{Logical; if TRUE, print progress messages. Defaults to FALSE.}
}
\value{
A list containing results from all analyses
}
\description{
Runs the full Orangutan morphometric analysis pipeline.
}
\examples{
\donttest{
# Create a tiny example dataset in a temporary file
tmp <- tempfile(fileext = ".csv")
toy_data <- data.frame(
  species = c("A", "A", "B", "B", "C", "C"),
  trait1  = c(1, 2, 5, 6, 9, 10),
  trait2  = c(3, 4, 7, 8, 11, 12),
  trait3  = c(2, 3, 6, 7, 10, 11)
)
write.csv(toy_data, tmp, row.names = FALSE)

# Create a temporary output directory
out_dir <- tempdir()

# Set a named list of seeds for reproducibility
seeds <- list(betadisper = 123, permanova = 456)

# Run Orangutan on the toy dataset
res <- run_orangutan(
  data_path = tmp,
  output_dir = out_dir,
  seeds = seeds,
  verbose = FALSE
)

# Inspect returned object
str(res)

# Clean up temporary dataset file
unlink(tmp)
}
}
