% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{add_QC}
\alias{add_QC}
\title{Add quality control samples to the plate}
\usage{
add_QC(
  plate,
  lqc_conc,
  mqc_conc,
  hqc_conc,
  extra = NULL,
  n_qc = 3,
  qc_serial = TRUE,
  reg = TRUE,
  group = NA
)
}
\arguments{
\item{plate}{PlateObj object}

\item{lqc_conc}{low quality control concentration}

\item{mqc_conc}{medium quality control concentration}

\item{hqc_conc}{high quality control concentration}

\item{extra}{numeric vector of extra QC concentrations.}

\item{n_qc}{number of QC sets. Default is 3}

\item{qc_serial}{logical. If TRUE, QCs are placed serially}

\item{reg}{logical. Indicates if restrictions should not be applied to the QC samples. Default is TRUE}

\item{group}{A string for bioanalytical group.}
}
\value{
PlateObj
}
\description{
A function to add QCs to plate. This function assumes adherence to
ICH guideline M10 on bioanalytical method validation and study sample analysis Geneva, Switzerland (2022).
If you are not following this guideline, you can set `reg = TRUE` to ignore the restrictions.
}
