\name{calibrate_temperature}
\alias{calibrate_temperature}
\title{Calibrate Softmax Temperature Parameter}
\description{
Selects the optimal temperature parameter for softmax PSRI aggregation
using perplexity targeting. The temperature controls how sharply the
softmax concentrates weight on the dominant component(s).
}
\usage{
calibrate_temperature(
  component_profiles,
  target_perplexity = 2.0,
  T_range = c(0.01, 2.0),
  tolerance = 0.05
)
}
\arguments{
  \item{component_profiles}{A list of numeric vectors, where each vector
    represents a set of PSRI component scores from representative
    replicates.}
  \item{target_perplexity}{Numeric. Target effective number of components.
    Default is 2.0.}
  \item{T_range}{Numeric vector of length 2. Search range for T.
    Default is \code{c(0.01, 2.0)}.}
  \item{tolerance}{Numeric. Convergence tolerance. Default is 0.05.}
}
\value{
  A list with:
  \describe{
    \item{optimal_T}{The calibrated temperature parameter.}
    \item{mean_perplexity}{Mean perplexity at the optimal T.}
    \item{profile_perplexities}{Per-profile perplexity values.}
    \item{target_perplexity}{The specified target.}
    \item{search_range}{The search range used.}
  }
}
\details{
Perplexity measures effective components receiving meaningful weight:
\deqn{Perplexity = \exp\left(-\sum_i W_i \log W_i\right)}

A perplexity of 2.0 (default target, for 3 components) balances
signal extraction with robustness. The calibration uses bisection
search over the provided range.
}
\examples{
profiles <- list(
  corn_control   = c(0.80, 0.90, 0.60),
  corn_treated   = c(0.50, 0.40, 0.55),
  barley_control = c(0.35, 0.30, 0.45),
  barley_treated = c(0.20, 0.15, 0.50)
)
cal <- calibrate_temperature(profiles)
cal$optimal_T
cal$mean_perplexity
}
\seealso{\code{\link{softmax_weights}}, \code{\link{compute_psri_sm}}}
