% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmap.R
\name{bmap}
\alias{bmap}
\title{Biomass Accumulation and Partitioning (bmap)}
\usage{
bmap(data)
}
\arguments{
\item{data}{A data frame with column:
\itemize{
\item \code{Gen}: Character vector of Genotype IDs.
\item \code{LDW_PI, LDW_PII, LDW_PIII}: Leaf dry weight (LDW) for three distinct phases I-III (PI-PIII).
\item \code{CDW_PI, CDW_PII, CDW_PIII}: Cane/crop dry weight (CDW) for three distinct phases I-III (PI-PIII).
\item \code{RDW_PI}: Root dry weight (RDW) for phase I (PI).
\item \code{RL_PI}: Root length (RL) for phase I (PI).
\item \code{PH_PI}: Plant height (PH) for phase I (PI).
}}
}
\value{
A list of result columns:
\itemize{
\item \code{Gen}: Character vector of genotype IDs.
\item \code{TBM_PI, TBM_PII, TBM_PIII}: Total above-ground biomass for three distinct phases I-III (PI-PIII).
\item \code{BPL_PI, BPL_PII, BPL_PIII}: Biomass partitioning to leaf for three distinct phases I-III (PI-PIII).
\item \code{BPC_PI, BPC_PII, BPC_PIII}: Biomass partitioning to cane (crop) for three distinct phases I-III (PI-PIII).
\item \code{RSRDW}: Root-to-shoot ratio based on dry weight
\item \code{RSRL}: Root-to-shoot ratio based on length
}
}
\description{
This function computes total above-ground biomass (TBM), root:shoot ratios, and biomass partitioning to leaf and cane/crop yield across stages/phases PI–PIII. For more details see Krishnapriya et al. (2020) \url{doi:10.37580/JSR.2019.2.9.150-163}.
Here observations are recorded on the variables-Plant height (PH), Root length (RL), Leaf dry weight (LDW), Cane dry weight (CDW), and Root dry weight (RDW) at the distinct time interval (number of days between observations recorded) phases (PI-PIII)
}
\examples{
# Creating a sample dataset
df <- data.frame(
Gen = c("V1","V2","V3"),
PH_PI  = c(161.0,144.0,158.0),
PH_PII = c(212.0,189.0,200.0),
PH_PIII= c(243.0,223.0,240.0),
RL_PI  = c(98.2,83.5,72.7),
LDW_PI = c(83.9,136.1,137.6),
CDW_PI = c(36.1,55.9,57.3),
RDW_PI = c(17.7,19.2,12.4),
LDW_PII= c(138.5,193.2,183.0),
CDW_PII= c(76.2,136.4,145.0),
LDW_PIII=c(292.2,386.5,450.1),
CDW_PIII=c(190.4,336.8,323.4)
)
bmap(df)

}
\references{
Krishnapriya, V., Arunkumar, R., Gomathi, R. and Vasantha, S. (2020). \url{doi:10.37580/JSR.2019.2.9.150-163}.
}
