% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_one_step.R
\name{one_step_all}
\alias{one_step_all}
\title{Analyze Ligand-Receptor Pair Correlations and Projection Scores (Across All Cell Types)}
\usage{
one_step_all(
  rna,
  lr_database,
  sample_col,
  cell_type_col,
  id_sep,
  min_cells = 50,
  min_samples = 10,
  min_cell_ratio = 0.1,
  min_sample_ratio = 0.1,
  cor_method = "spearman",
  adjust_method = "BH",
  min_adjust_p = 0.05,
  min_cor = 0,
  min_r2 = 0,
  min_fstat = 0,
  num_cores = 10,
  verbose = TRUE
)
}
\arguments{
\item{rna}{A Seurat object or a matrix containing single-cell RNA expression data.}

\item{lr_database}{A data frame of ligand-receptor pairs with columns "ligand_gene_symbol" and "receptor_gene_symbol".}

\item{sample_col}{Metadata column name (character) for sample identifiers in Seurat mode; Matrix mode uses column index (numeric).}

\item{cell_type_col}{Metadata column name (character) for cell type in Seurat mode; Matrix mode uses column index (numeric).}

\item{id_sep}{Separator used in matrix column names to split sample and cell type (e.g., \verb{--} for "Cardiac--sample1"). Only used in Matrix mode.}

\item{min_cells}{Minimum number of cells per sample for both sender and receiver (numeric, default 50). Only used in Seurat mode.}

\item{min_samples}{Minimum number of valid samples to proceed (numeric, default 10).}

\item{min_cell_ratio}{Minimum ratio of cells expressing ligand and receptor genes in sender or receiver cells (numeric, default 0.1). Only used in Seurat mode.}

\item{min_sample_ratio}{Minimum ratio of samples in which both the ligand and receptor genes must be expressed (numeric, default 0.1).}

\item{cor_method}{Correlation method: "spearman" (default), "pearson", or "kendall".}

\item{adjust_method}{P-value adjustment method (default "BH" for Benjamini-Hochberg).
Options: "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none".}

\item{min_adjust_p}{Adjusted p-value threshold for significance (numeric, default 0.05).}

\item{min_cor}{Minimum correlation coefficient threshold (numeric, default 0). Must be \eqn{\ge}{>=} 0.}

\item{min_r2}{Minimum R-squared threshold for the linear regression model (numeric, default 0). Must be \eqn{\ge}{>=} 0.}

\item{min_fstat}{Minimum F-statistic threshold for the linear regression model (numeric, default 0). Must be \eqn{\ge}{>=} 0.}

\item{num_cores}{Number of CPU cores for parallel processing (numeric, default 10). Automatically capped at (system cores - 1).}

\item{verbose}{Logical indicating whether to print progress messages (logical, default: TRUE).}
}
\value{
Two data frames with columns:
\item{ligand, receptor}{Ligand and receptor gene symbols (res1/res2).}
\item{cor}{Correlation coefficient (res1/res2).}
\item{p_val}{Raw p-value (res1/res2).}
\item{adjust.p}{Adjusted p-value (res1/res2).}
\item{sender, receiver}{Sender and receiver cell types (res1/res2).}
\item{slope}{Slope of the linear regression model (res1/res2).}
\item{intercept}{Intercept of the linear regression model (res1/res2).}
\item{r2}{Coefficient of determination (R-squared) of the linear regression model (res1/res2).}
\item{fstat}{F-statistic of the linear regression model (res1/res2).}
\item{sample}{Sample identifier (res2).}
\item{score}{Projection score (raw co-expression intensity) (res2).}
\item{normalized_score}{Normalized score scaled between 0-1 (res2).}

Returns \code{NULL} if:
\itemize{
\item No cell types are found in the metadata.
\item Insufficient samples or cells remain after filtering.
\item No ligand-receptor pairs pass the filtering thresholds.
\item One or both of the specified sender and receiver cell types are missing in the data.
\item Fewer than two valid samples remain after filtering based on minimum cell number per sample.
}
}
\description{
Performs integrated analysis of ligand-receptor (LR) pairs through two consecutive phases:
(1) Filters LR pairs and analyzes correlations across all cell types;
(2) Calculates projection scores based on regression models for valid pairs.
Returns comprehensive results combining statistical metrics. This function supports both Seurat objects and
average expression matrices (matrix of gene expression data with cell types and samples as column names).
}
\examples{
\donttest{
  data(matrix_object)
  data(lr_db)

  # Integrated analysis across all cell types
  res_all <- one_step_all(
    rna = matrix_object,
    lr_database = lr_db,
    sample_col = 2,
    cell_type_col = 1,
    id_sep = "--",
    min_samples = 10,
    min_sample_ratio = 0.1,
    min_adjust_p = 0.05,
    num_cores = 1,
    verbose = TRUE
    )

  if (!is.null(res_all)) {
    print(head(res_all$res1))
    print(head(res_all$res2))
  }
}
}
