% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.profileLadder.R
\name{plot.profileLadder}
\alias{plot.profileLadder}
\title{Plotting Development Profiles}
\usage{
\method{plot}{profileLadder}(
  x,
  xlab = "Development period",
  ylab = "Cumulative claims",
  main = "",
  default.legend = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of the class \code{profileLadder} (output form
\code{parallelReserve()}, \code{mcReserve()}, or \code{as.profileLadder()}}

\item{xlab}{label for the x axis}

\item{ylab}{label for the y axis}

\item{main}{title of the plot}

\item{default.legend}{logical to indicate whether a default plot legend
(utilizing the information from the R class \code{profileLadder}) should be
provided  (DEFAULT)}

\item{...}{other graphical parameters to plot}
}
\value{
A graph with the observed functional development profiles from the
input run-off triangle, the estimated/predicted functional segments (i.e.,
functional profile completion provided by the corresponding estimation
method---PARALLAX, REACT, or MACRAME) the and the true future profiles
(if these are available)
}
\description{
The function provides a graphical representation of the functional profiles
estimated by the PARALLAX, REACT, or MACRAME algorithm (see Maciak,
Mizera, and Pesta (2022) for further details). The function takes an object
of the class \code{profileLadder} which is the output of the
\code{parallelReserve()} function or the \code{mcReserve()} function.
Alternatively, the function can be also applied to visualise the run-off triangle
itself---if the triangle is of the class \code{profileLadder}.
}
\examples{
## completed run-off triangle with the 'unknown' (future) payments
print(triangle <- GFCIB$bodilyInjury[1:15, 1:15])
plot(mcReserve(triangle))

## completed run-off triangle with unknown future
print(observed(triangle))
plot(mcReserve(observed(triangle)))

## the run-off triangle with future payments without MACRAME completion
plot(as.profileLadder(triangle))



}
\seealso{
\code{\link[=as.profileLadder]{as.profileLadder()}}, \code{\link[=parallelReserve]{parallelReserve()}}, \code{\link[=mcReserve]{mcReserve()}}
}
