% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{clean_blink}
\alias{clean_blink}
\title{Automatically clean Eyelink marked blinks.}
\usage{
clean_blink(
  data = data,
  BlinkPadding = c(100, 100),
  Delta = NA,
  MaxValueRun = 5,
  NAsAroundRun = c(2, 2),
  LogFile = NULL
)
}
\arguments{
\item{data}{A data frame object created from \code{ppl_select_recorded_eye}.}

\item{BlinkPadding}{A numeric vector of length two containing values (in
msec) to pad the marked blink creating a window within which to operate
the cleanup.}

\item{Delta}{A numeric value specifying the maximal difference between
subsequent pupil values in order to mark greater differences for removal. If
NA, the delta will be estimated from the data using the 95th percentile
value.}

\item{MaxValueRun}{A numeric value specifying the maximal run of existing
values flanked by NAs that could be targeted for removal.}

\item{NAsAroundRun}{A numeric vector of length two containing values (in
number of subsequent NA) to be used to identify straggler runs of data
that could be removed.}

\item{LogFile}{A character string indicating the file name (with extension)
of the log file to be created/written. The file keeps track of which events
have been cleaned. We suggest "BlinkCleanupLog.rds".}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{clean_blink} performs two stage automated clean-up of blinks
in the pupil and gaze coordinate data.
}
\examples{
# Load example data
data("Pupilex3")

# Writing log file to temporary folder for the example
dat <- clean_blink(Pupilex3, BlinkPadding = c(100, 100), Delta = 5,
                   MaxValueRun = 5, NAsAroundRun = c(2,2),
                   LogFile = paste0(tempdir(),"/BlinkCleanupLog.rds"))

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Cleanup", package="PupilPre")

}
