% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq.test.0vs1.R
\name{dq.test.0vs1}
\alias{dq.test.0vs1}
\title{Test for the Presence of a Break within a Range of Quantiles}
\usage{
dq.test.0vs1(y, x, q.L, q.R, n.size = 1)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}), excluding the constant term.}

\item{q.L}{A numeric value specifying the lower bound of the quantile range.}

\item{q.R}{A numeric value specifying the upper bound of the quantile range.}

\item{n.size}{An integer specifying the size of the cross-section (\eqn{N}).}
}
\value{
A numeric scalar representing the DQ test statistic.
}
\description{
This procedure computes test statistics for detecting a single structural break
within a range of quantiles. The null hypothesis is that there is no break
in any quantile in the specified range; the alternative is that at least one
quantile in the range is affected by a break.
}
\examples{
## data
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")]

## qunatile range (left and right limits)
q.L = 0.2
q.R = 0.8

## N
n.size = 1

# dq-test
result = dq.test.0vs1(y, x, q.L, q.R, n.size)
print(result)

}
\references{
Koenker, R. and Bassett Jr, G. (1978).
Regression quantiles. \emph{Econometrica}, \emph{46}(1), 33–50.

Qu, Z. (2008).
Testing for structural change in regression quantiles.
\emph{Journal of Econometrics}, \emph{146}(1), 170–184.
}
