% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rq.est.full.R
\name{rq.est.full}
\alias{rq.est.full}
\title{Estimating Break Sizes and Confidence Intervals Given Break Dates}
\usage{
rq.est.full(y, x, v.tau, vec.date, n.size = 1)
}
\arguments{
\item{y}{A numeric vector of dependent variables (\eqn{NT \times 1}).}

\item{x}{A numeric matrix of regressors (\eqn{NT \times p}).}

\item{v.tau}{A numeric value representing the quantile of interest.}

\item{vec.date}{A numeric vector of break dates, specified by the user.}

\item{n.size}{An integer specifying the size of the cross-section (\eqn{N}).}
}
\value{
An object from the quantile regression estimates, \code{rq()}, with structural breaks.
}
\description{
This procedure estimates a linear quantile regression
given a set of break dates. It is structured to compute break sizes between adjacent regimes and their confidence intervals.
}
\examples{
## data
data(gdp)
y = gdp$gdp
x = gdp[,c("lag1", "lag2")]

## quantile
v.tau = 0.8

## break date
vec.date = 146

# cross-sectional size
n.size = 1

## estimation
rq.est.full(y, x, v.tau, vec.date, n.size)



}
\references{
Koenker, R. and G. Bassett Jr. (1978).
Regression Quantiles. \emph{Econometrica}, 46(1), 33–50.

Oka, T. and Z. Qu (2011).
Estimating Structural Changes in Regression Quantiles.
\emph{Journal of Econometrics}, 162(2), 248–267.
}
