% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POSIXct2D.R
\name{asDatePOSIXct}
\alias{asDatePOSIXct}
\title{Conversion from POSIXct to Date}
\usage{
asDatePOSIXct(x, tz = "")
}
\arguments{
\item{x}{A POSIXct vector}

\item{tz}{An optional timezone string}
}
\value{
A vector of \code{Date} objects
}
\description{
Conversion from POSIXct to Date
}
\details{
This function provides a direct conversion from POSIXct to Date. As of
R-3.5.1, conversion from POSIXct to Date creates an intermediate POSIXlt
object. This intermediate POSIXlt object uses a non-trivial amount of
memory. The direct conversion is more memory efficient, and therefore
approximately twice as fast as the current solution in base R.
}
\examples{
p <- .POSIXct(1540181413, "America/Chicago")
as.Date(p)                     # Using UTC timezone
as.Date(p, "America/Chicago")  # Using local timezone
asDatePOSIXct(p)               # Direct, using local timezone
}
\author{
Joshua Ulrich
}
