% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_calls.R
\name{summary_calls}
\alias{summary_calls}
\title{summary_calls}
\usage{
summary_calls(
  inChASM,
  minTotal = 60000,
  minPosterior = 0.95,
  ignoreUnusual = FALSE,
  printProtocol = FALSE
)
}
\arguments{
\item{inChASM}{the result of combining both autosomal and sca analyses}

\item{minTotal}{minimum total for autosomal or sca analyses}

\item{minPosterior}{minimum value maxP can take (i.e. minimum posterior probability accepted)}

\item{ignoreUnusual}{filter our unusual observations?}

\item{printProtocol}{print protocol column?}
}
\value{
combined calls
}
\description{
Combine both autosomal and sex chromosomal analyses into one output
}
\examples{
example_calls <- runChASM(rawReadCountsIn = example_data)
summary_calls(inChASM = example_calls, minTotal = 6e4, minPosterior = 0.95)

}
