% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Umix.R
\name{Umix}
\alias{Umix}
\title{NPMLE for Uniform Scale Mixtures}
\usage{
Umix(x, ...)
}
\arguments{
\item{x}{Data: Sample Observations}

\item{...}{other parameters to pass to KWDual to control optimization}
}
\value{
An object of class density with components: 
     \item{x}{points of  evaluation on the domain of the density} 
     \item{y}{estimated mass at the points x of the mixing density} 
     \item{g}{the estimated mixture density function values at x} 
     \item{logLik}{Log likelihood value at the proposed solution} 
     \item{status}{exit code from the optimizer}
}
\description{
Kiefer-Wolfowitz Nonparametric MLE for Uniform Scale Mixtures
}
\details{
Kiefer-Wolfowitz MLE for the mixture model \eqn{Y \sim U[0,T], \; T \sim G} 
No gridding is required since mass points of the mixing distribution, \eqn{G},
must occur at the data points.  This formalism is equivalent, as noted by
Groeneboom and Jongbloed (2014) to the Grenander estimator of a monotone
density in the sense that the estimated mixture density, i.e. the marginal
density of \eqn{Y}, is the Grenander estimate,  see the remark at the end
of their Section 2.2.  See also \code{demo(Grenander)}.  Note that this
refers to the decreasing version of the Grenander estimator, for the 
increasing version try standing on your head.
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}.  Volume 27, Number 4 (1956), 887-906.

Groeneboom, P. and G. Jongbloed, \emph{Nonparametric Estimation under 
Shape Constraints}, 2014, Cambridge U. Press.
}
\author{
Jiaying Gu and Roger Koenker
}
\keyword{nonparametric}
