% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_recalculate.R
\name{rd_recalculate}
\alias{rd_recalculate}
\title{Recalculate and Verify Calculated Fields in REDCap Data}
\usage{
rd_recalculate(
  project = NULL,
  data = NULL,
  dic = NULL,
  event_form = NULL,
  exclude = NULL
)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}

\item{exclude}{Optional. Character vector of field names to exclude from recalculation.}
}
\value{
A list with:
\describe{
\item{data}{The dataset with new \verb{_recalc} fields for any differing calculated fields.}
\item{dictionary}{Updated dictionary including the new \verb{_recalc} fields.}
\item{event_form}{The \code{event_form} passed in (if applicable).}
\item{results}{Summary report of the recalculation process, including tables of discrepancies.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Recalculates fields marked as calculated in the REDCap dictionary, compares them with the original values, and reports discrepancies. If any differences are found, new recalculated fields are added to the dataset and dictionary with \verb{_recalc} appended to the names.
}
\details{
\itemize{
\item Fields of type \code{calc} in the dictionary are recalculated.
\item Recalculated values are compared with the original values.
\item If differences exist, new fields \verb{[field_name]_recalc} are added to the dataset and dictionary.
\item Works for single-event projects; for longitudinal projects, \code{event_form} must be provided.
\item Fields with incomplete branching logic or smart variables may fail to recalculate.
}
}
\examples{
# Recalculate all calculated fields
\dontrun{
results <- rd_recalculate(
  data = covican$data,
  dic = covican$dictionary,
  event_form = covican$event_form
)
}

# Recalculate but exclude some variables
\dontrun{
results <- rd_recalculate(
  project = covican,
  exclude = c("age", "screening_fail_crit")
)
}

}
