% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IW.R
\name{IW}
\alias{IW}
\title{The Inverse Weibull family}
\usage{
IW(mu.link = "log", sigma.link = "log")
}
\arguments{
\item{mu.link}{defines the mu.link, with "log" link as the default for the mu parameter.}

\item{sigma.link}{defines the sigma.link, with "log" link as the default for the sigma.}
}
\value{
Returns a gamlss.family object which can be used to fit a IW distribution in the \code{gamlss()} function.
}
\description{
The Inverse Weibull distribution
}
\details{
The Inverse Weibull distribution with parameters \code{mu}, 
\code{sigma} has density given by

\eqn{f(x) = \mu \sigma x^{-\sigma-1} \exp(\mu x^{-\sigma})}

for \eqn{x > 0}, \eqn{\mu > 0} and \eqn{\sigma > 0}
}
\examples{
# Example 1
# Generating some random values with
# known mu and sigma
y <- rIW(n=100, mu=5, sigma=2.5)

# Fitting the model
require(gamlss)

mod <- gamlss(y~1, mu.fo=~1, sigma.fo=~1, family='IW',
              control=gamlss.control(n.cyc=5000, trace=FALSE))

# Extracting the fitted values for mu, sigma and nu
# using the inverse link function
exp(coef(mod, what='mu'))
exp(coef(mod, what='sigma'))

# Example 2
# Generating random values under some model
n <- 200
x1 <- rpois(n, lambda=2)
x2 <- runif(n)
mu <- exp(2 + -1 * x1)
sigma <- exp(2 - 2 * x2)
x <- rIW(n=n, mu, sigma)

mod <- gamlss(x~x1, mu.fo=~1, sigma.fo=~x2, family=IW,
              control=gamlss.control(n.cyc=5000, trace=FALSE))

coef(mod, what="mu")
coef(mod, what="sigma")
}
\references{
Almalki, S. J., & Nadarajah, S. (2014). Modifications of the 
Weibull distribution: A review. Reliability Engineering & 
System Safety, 124, 32-55.

Drapella, A. (1993). The complementary Weibull distribution: 
unknown or just forgotten?. Quality and reliability engineering 
international, 9(4), 383-385.
}
\seealso{
\link{dIW}
}
\author{
Johan David Marin Benjumea, \email{johand.marin@udea.edu.co}
}
