% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcurve.R
\name{as_zcurve}
\alias{as_zcurve}
\title{Transform RoBMA object into z-curve}
\usage{
as_zcurve(x, significance_level = stats::qnorm(0.975), max_samples = 1000)
}
\arguments{
\item{x}{A RoBMA object}

\item{significance_level}{Significance level used for computation of z-curve
estimates.}

\item{max_samples}{Maximum number of samples from the posterior distribution
that will be used for estimating z-curve estimates.}
}
\value{
\code{as_zcurve} returns a list of tables of class 'zcurve_RoBMA'.
}
\description{
This function transforms the estimated RoBMA model into a
z-curve object that can be further summarized and plotted.
Only available for normal-normal models estimated using the spike-and-slab
algorithm (i.e., \code{algorithm = "ss"}). See
\insertCite{bartos2025zcurve;textual}{RoBMA} and
\href{../doc/ZCurveDiagnostics.html}{\code{vignette("ZCurveDiagnostics", package = "RoBMA")}}
for more detail.
}
\examples{
\dontrun{
# using the example data from Anderson et al. 2010 and fitting the default model
# (note that the model can take a while to fit)
fit <- RoBMA(r = Anderson2010$r, n = Anderson2010$n,
             study_names = Anderson2010$labels, algorithm = "ss")

zcurve_fit <- as_zcurve(fit)
summary(zcurve_fit)
}

}
