% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samLL.R
\name{predict.samLL}
\alias{predict.samLL}
\title{Prediction function for S3 class \code{"samLL"}}
\usage{
\method{predict}{samLL}(object, newdata, thol = 0.5, ...)
}
\arguments{
\item{object}{An object with S3 class \code{"samLL"}.}

\item{newdata}{Numeric test matrix with \code{n} rows and \code{d} columns.}

\item{thol}{Decision-value threshold used to convert probabilities to labels. The default value is \code{0.5}.}

\item{\dots}{Additional arguments passed to methods; currently unused.}
}
\value{
\item{probs}{
  Estimated posterior probabilities as an \code{n} by
  \code{length(lambda)} matrix.
}
\item{labels}{
  Predicted class labels (\code{0}/\code{1}) as an \code{n} by
  \code{length(lambda)} matrix.
}
}
\description{
Predict class probabilities and labels for test data.
}
\details{
The test matrix is rescaled using the training \code{X.min}/\code{X.ran},
truncated to \code{[0, 1]}, and expanded with the same spline basis used
during training.
}
\seealso{
\code{\link{samLL}}
}
