% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{groupmetric_2panel}
\alias{groupmetric_2panel}
\title{groupmetric_2panel
Draws plots of a group fairness metric with a second panel underneath}
\usage{
groupmetric_2panel(
  objs,
  labels = names(objs),
  col = 1:length(objs),
  yrange = NULL,
  ci_col = col,
  highlight = NULL,
  logscale = FALSE,
  lpos = c(1, 0),
  yrange_lower = NULL,
  legend_title = ""
)
}
\arguments{
\item{objs}{list of fairness objects. Each should contain sub-objects 'x', 'y' and 'ci', which specify x and y values and half-widths of confidence intervals around y.}

\item{labels}{labels to use in legend}

\item{col}{line colours}

\item{yrange}{limit of y axis; defaults to 0,1}

\item{ci_col}{confidence envelope colours. These will be transparent.}

\item{highlight}{if non-null, draw a point at a particular cutoff}

\item{logscale}{if TRUE, draw with log-scale.}

\item{lpos}{legend position; as accepted by ggplot legend.position}

\item{yrange_lower}{y range for lower plot. If NULL, generates automatically}

\item{legend_title}{title for legend, defaults to nothing}
}
\value{
Silently return ggplot object
}
\description{
groupmetric_2panel
Draws plots of a group fairness metric with a second panel underneath
}
\examples{
# See vignette
}
