% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svem_random_table_multi.R
\name{svem_random_table_multi}
\alias{svem_random_table_multi}
\title{Generate a Random Prediction Table from Multiple SVEMnet Models (no refit)}
\usage{
svem_random_table_multi(
  objects,
  n = 1000,
  mixture_groups = NULL,
  debias = FALSE,
  range_tol = 1e-08,
  numeric_sampler = c("random", "uniform")
)
}
\arguments{
\item{objects}{A list of fitted \code{svem_model} objects returned by
\code{SVEMnet()}. Each object must contain a valid \code{$sampling_schema}
produced by the updated \code{SVEMnet()} implementation. A single model is
also accepted and treated as a length-one list.}

\item{n}{Number of random points to generate (rows in the output tables).
Default is \code{1000}.}

\item{mixture_groups}{Optional list of mixture constraint groups. Each group
is a list with elements \code{vars}, \code{lower}, \code{upper}, \code{total}
(see \emph{Notes on mixtures}). Mixture variables must be numeric-like and
must also appear in the models' \code{predictor_vars} (that is, they must
be used as predictors in all models).}

\item{debias}{Logical; if \code{TRUE}, apply each model's calibration during
prediction when available (for Gaussian fits). This is passed to
\code{predict.svem_model()}. Default is \code{FALSE}.}

\item{range_tol}{Numeric tolerance for comparing numeric ranges across models
(used when checking that all \code{$sampling_schema$num_ranges} agree).
Default is \code{1e-8}.}

\item{numeric_sampler}{Sampler for non-mixture numeric predictors:
\code{"random"} (default), or \code{"uniform"}.
\itemize{
\item \code{"random"}: random Latin hypercube when the \pkg{lhs} package
is available; otherwise independent uniforms via \code{runif()}.
\item \code{"uniform"}: independent uniform draws within numeric ranges
(fastest; no \pkg{lhs} dependency).
}}
}
\value{
A list with three data frames:
\itemize{
\item \code{data}: the sampled predictor settings, one row per random point.
\item \code{pred}: one column per response, aligned to \code{data} rows.
\item \code{all}: \code{cbind(data, pred)} for convenience.
}
Each prediction column is named by the model's response (left-hand side)
with a "_pred" suffix (for example, "y1_pred"). If that name would collide
with a predictor name or with another prediction column, the function stops
with an error and asks the user to rename the response or predictor.
}
\description{
Samples the original predictor factor space cached in fitted \code{svem_model}
objects and computes predictions from each model at the same random points.
This is intended for multiple responses built over the same factor space and
a deterministic factor expansion (for example via a shared
\code{\link{bigexp_terms}}), so that a shared sampling schema is available.
}
\details{
No refitting is performed. Predictions are obtained by
averaging per-bootstrap member predictions on the requested scale.

All models must share an identical predictor schema. Specifically, their
\code{$sampling_schema} entries must agree on:
\itemize{
\item The same \code{predictor_vars} in the same order.
\item The same \code{var_classes} for each predictor.
\item Identical factor \code{levels} and level order for all categorical
predictors.
\item Numeric \code{num_ranges} that match within \code{range_tol} for all
continuous predictors.
\item When present, the same \code{blocking} set (up to order).
}
The function stops with an informative error message if any of these checks fail.

\strong{Discrete numeric predictors (automatic).}
If any supplied model stores discrete-numeric sampling information in its
\code{$sampling_schema}, this function will automatically respect it (no
separate user argument).

In the updated \code{SVEMnet()} implementation this information is stored as:
\itemize{
\item \code{$sampling_schema$discrete_numeric}: a character vector of discrete
numeric variable names; and
\item \code{$sampling_schema$discrete_levels}: a named list mapping those
names to allowed numeric values.
}
(Older objects may use \code{$sampling_schema$discrete_values} instead of
\code{discrete_levels}; this function accepts both for backward compatibility.)

Discrete numeric variables are sampled independently (uniform over allowed
values) and are excluded from Latin hypercube sampling; LHS (when used) is
applied only to the remaining continuous numeric predictors. Discrete numeric
variables are not allowed to be mixture variables.

Models may be Gaussian or binomial. For binomial fits, predictions are
returned on the probability scale (that is, on the response scale) by default,
consistent with the default behaviour of \code{predict.svem_model()}.
}
\section{Typical workflow}{

\enumerate{
\item Build a deterministic expansion (for example with \code{\link{bigexp_terms}})
and fit several \code{SVEMnet()} models for different responses on
the same factor space, using the same expansion / sampling settings.
\item Ensure that the fitted models were created with a version of
\code{SVEMnet()} that populates \code{$sampling_schema}.
\item Collect the fitted models in a list and pass them to
\code{svem_random_table_multi()}.
\item Use \code{$data} (predictors), \code{$pred} (response columns), or
\code{$all} (\code{cbind(data, pred)}) for downstream plotting,
summarization, or cross-response comparison.
}
}

\section{Blocking variables}{

If the models were fit using a \code{bigexp_spec} that included blocking
variables (for example \code{blocking = c("Operator", "Plate_ID")}) and
\code{SVEMnet()} stored these in \code{$sampling_schema$blocking}, then
\code{svem_random_table_multi()} will:
\itemize{
\item treat those variables as blocking factors; and
\item hold them fixed at a single value across the sampled table.
}

Specifically:
\itemize{
\item For blocking numeric variables, the function uses the midpoint of the
recorded numeric range, \code{(min + max) / 2}, for all rows. If the
variable also has stored discrete support, the midpoint is snapped
deterministically to the nearest allowed discrete value.
\item For blocking categorical variables, the function uses a single
reference level equal to the most frequent observed level (mode) in the
training data, with ties broken deterministically; if the mode is
unavailable, it falls back to the first stored level.
}

Blocking variables are not allowed to appear in \code{mixture_groups}. If
any mixture group tries to use a blocking variable, the function stops with
an error.

When no blocking information is present in \code{$sampling_schema} (for
example for models fit without a \code{bigexp_spec} or without blocking),
the behavior is unchanged from earlier versions: all predictors are sampled
according to the rules described under "Sampling strategy".
}

