% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_beta.R
\name{sb_resample_groups}
\alias{sb_resample_groups}
\title{Generate correlated design replicates for a set of groups}
\usage{
sb_resample_groups(
  X_norm,
  groups,
  B = 100,
  jitter = 1e-06,
  seed = NULL,
  use.parallel = FALSE,
  cache = NULL
)
}
\arguments{
\item{X_norm}{Normalised design matrix.}

\item{groups}{Correlation structure. Either a list as returned by
\code{\link[=sb_group_variables]{sb_group_variables()}} or a vector of group labels matching the columns of
\code{X_norm}.}

\item{B}{Number of replicates to generate.}

\item{jitter}{Numeric value added to covariance diagonals for stability.}

\item{seed}{Optional integer seed for reproducibility. The seed is scoped via
\code{\link[withr:with_seed]{withr::with_seed()}} so the caller's RNG state is restored on exit.}

\item{use.parallel}{Logical; when \code{TRUE}, compute the resampled designs using
a parallel backend when available.}

\item{cache}{Optional environment or named list used to cache previously
generated surrogates. Passing the same cache across calls reuses draws for
identical groups.}
}
\value{
An object of class \code{sb_resamples}, i.e. a list of length \code{B} whose
elements are resampled design matrices. The object exposes per-group
diagnostics in its \code{"diagnostics"} attribute and returns the cache via the
\code{"cache"} attribute for reuse.
}
\description{
Generate correlated design replicates for a set of groups
}
\details{
When every group has size one (no correlated variables) the function
simply returns \code{B} copies of \code{X_norm}. A warning is issued in that situation
so downstream code can avoid mistaking the replicated designs for genuinely
resampled surrogates. The covariance matrices underpinning each correlated
draw are cached in the supplied \code{cache} environment; reusing the environment
across calls lets \code{sb_resample_groups()} skip redundant covariance
decompositions for identical groups and speeds up iterative workflows.
}
