% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_bandwidths_and_edgecorr.R
\name{calc.bandwidths.and.edgecorr}
\alias{calc.bandwidths.and.edgecorr}
\title{Compute bandwidths and edge-correction factors for spatio-temporal kernel intensity estimation}
\usage{
calc.bandwidths.and.edgecorr(
  X,
  s.region,
  t.region,
  n.grid,
  epsilon = NULL,
  delta = NULL
)
}
\arguments{
\item{X}{A numeric matrix or data frame with at least three columns giving the \eqn{x}-, \eqn{y}-,
and time coordinates \eqn{t} of observed spatio-temporal events. Each row corresponds to one event.}

\item{s.region}{A numeric matrix with two columns giving the vertices of the polygonal spatial
observation window in order (the first vertex need not be repeated at the end).}

\item{t.region}{A numeric vector of length 2 giving the temporal observation window
\code{c(tmin, tmax)} with \code{tmin < tmax}.}

\item{n.grid}{An integer vector of length 3 giving the number of grid cells in the \eqn{x}, \eqn{y},
and time dimensions. Only \code{n.grid[3]} is used when estimating the temporal bandwidth.}

\item{epsilon}{Optional positive numeric. Spatial bandwidth. If \code{NULL}, estimated using
\code{bw.diggle}.}

\item{delta}{Optional positive numeric. Temporal bandwidth. If \code{NULL}, estimated using
\code{density(..., bw = "SJ-dpi")}.}
}
\value{
A list with components:
\describe{
\item{bw}{Numeric vector of length 3: \code{c(epsilon, epsilon, delta)}.}
\item{time}{Numeric vector of length \code{nrow(X)} giving temporal edge masses
\eqn{\int_{tmin}^{tmax} K_\delta(u-t_i)\,du}.}
\item{space}{Numeric vector of length \code{nrow(X)} giving spatial edge-correction
factors computed using the Diggle method for the polygonal window \code{s.region}.}
}
}
\description{
Computes spatial and temporal bandwidths for kernel-based estimation of the intensity of a
spatio-temporal point pattern. The spatial bandwidth is estimated from the spatial coordinates
using Diggle's (1985) mean-square error method via \code{\link[spatstat.explore]{bw.diggle}}.
The temporal bandwidth is estimated from the time coordinates using the Sheather--Jones
direct plug-in method (\code{bw = "SJ-dpi"}) as implemented in \code{\link[stats]{density}}.
}
\details{
Edge-correction factors are computed for Gaussian kernels as the kernel mass inside the
observation window: \eqn{c(x) = \int_W K_h(u-x)\,du}. The temporal correction is computed
exactly over \code{t.region}. The spatial correction is computed using the Diggle
edge-correction method as implemented in \code{spatstat.explore}, which accounts for the
polygonal spatial observation window.

The spatial window is converted to an \code{\link[spatstat.geom]{owin}} object, and the spatial
bandwidth is estimated using Diggle's mean-square error method via
\code{\link[spatstat.explore]{bw.diggle}} applied to the corresponding
\code{\link[spatstat.geom]{ppp}} object. Spatial edge-correction factors are computed using
the Diggle edge-correction method implemented in \code{spatstat.explore}.

The temporal bandwidth is selected using the Sheather--Jones direct plug-in method
(\code{bw = "SJ-dpi"}) as implemented in \code{\link[stats]{density}} over \code{t.region}.

The returned edge-correction factors are kernel masses inside the window. If you use them for
intensity estimation with edge correction, typical usage is to divide by these factors.
}
\examples{
  set.seed(123)
  X <- cbind(runif(100), runif(100), runif(100, 0, 10))
  s.region <- matrix(c(0,0, 1,0, 1,1, 0,1), ncol = 2, byrow = TRUE)
  t.region <- c(0, 10)
  n.grid <- c(25, 25, 20)
  res <- calc.bandwidths.and.edgecorr(X, s.region, t.region, n.grid)
  str(res)

}
\references{
Baddeley A, Rubak E, Turner R (2015).
\emph{Spatial Point Patterns: Methodology and Applications with R}.
Chapman and Hall/CRC Press.

Diggle, P.J. (1985).
A Kernel Method for Smoothing Point Process Data.
\emph{Journal of the Royal Statistical Society, Series C},
34, 138--147.
}
\seealso{
\code{\link[spatstat.explore]{bw.diggle}}, \code{\link[stats]{density}}
}
