% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{apply_to_columns}
\alias{apply_to_columns}
\title{Apply Function to Matrix Columns}
\usage{
apply_to_columns(X, FUN, extract = NULL, ..., verbose = FALSE)
}
\arguments{
\item{X}{Matrix or data frame where each column is a series to process.}

\item{FUN}{Function to apply to each column. Must accept a numeric vector
and return either a numeric vector of the same length or a list with
a named element (specified by \code{extract}).}

\item{extract}{Character string specifying which element to extract from
the function output if it returns a list. Default is NULL (use raw output).}

\item{...}{Additional arguments passed to FUN.}

\item{verbose}{Logical indicating whether to print progress messages.}
}
\value{
A data frame with the same number of rows as X, containing the
processed output for each column.
}
\description{
Applies a univariate filtering or transformation function to each column
of a matrix and returns a consolidated data frame. This utility enables
batch processing of panel data where each column represents a different
variable or series.
}
\examples{
X <- matrix(rnorm(200), ncol = 4)
colnames(X) <- c("A", "B", "C", "D")
result <- apply_to_columns(X, function(x) cumsum(x))

}
