% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_generics.R, R/class_Boxplot.R,
%   R/class_Slick.R
\docType{methods}
\name{Boxplot}
\alias{Boxplot}
\alias{Boxplot<-}
\alias{Boxplot,missing-method}
\alias{Boxplot,character_list-method}
\alias{Boxplot,Slick-method}
\alias{Boxplot<-,Slick-method}
\title{Methods for Creating, Accessing and Assigning \code{Boxplot} objects}
\usage{
Boxplot(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list(),
  Defaults = list("overall", "boxplot"),
  Misc = list()
)

Boxplot(Slick) <- value

\S4method{Boxplot}{missing}()

\S4method{Boxplot}{character_list}(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list(),
  Defaults = list("overall", "boxplot"),
  Misc = list()
)

\S4method{Boxplot}{Slick}(Code)

\S4method{Boxplot}{Slick}(Slick) <- value
}
\arguments{
\item{Code}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Label}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Description}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Value}{A numeric array with the stochastic performance indicator values for each
simulation (sim), operating model (OM), management procedure (MP), and performance indicator (PI).
Dimensions: c(\code{nsim}, \code{nOM}, \code{nMP}, and \code{nPI}).}

\item{Preset}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{Defaults}{A list object with default selections for the Boxplot}

\item{Misc}{A named list for additional miscellaneous information.}

\item{Slick}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{value}{A \code{\link[=Boxplot-class]{Boxplot-class()}} object}
}
\description{
The \code{Boxplot} function is used both to create and modify an \code{\link[=Boxplot-class]{Boxplot-class()}} object.
and to access and assign \code{Boxplot} for an object of class \code{\link[=Slick-class]{Slick-class()}}.
See \code{Details}.
}
\details{
Objects of class \code{Boxplot} are created with \code{Boxplot()}

Use \code{\link[=plotBoxplot]{plotBoxplot()}} to create the boxplot from the console.

Use the  \code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}} functions to
access and assign the values for an existing \code{Boxplot} object, see \code{Examples}
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{pt}: Portuguese
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in `Value
}

\subsection{Defaults}{

\code{Defaults} is used to select the plot options that are selected in the Boxplot.
It is a list of length 2, with the following requirements for the list elements:
\enumerate{
\item A character string. Options: 'overall' (default) or 'byom'
\item A character string. Options: 'boxplot' (default), 'violin', or 'both'
}

If unrecognized values are entered, the defaults will be used.
}
}
\section{Functions}{
\itemize{
\item \code{Boxplot(missing)}: Create an empty \code{Boxplot} object

\item \code{Boxplot(character_list)}: Create a populated \code{Boxplot} object

\item \code{Boxplot(Slick)}: Return \code{Boxplot} from a \code{\link[=Slick-class]{Slick-class()}} object

\item \code{Boxplot(Slick) <- value}: Assign a \code{\link[=Boxplot-class]{Boxplot-class()}} object to a \code{\link[=Slick-class]{Slick-class()}} object

}}
\examples{
# Generate dummy values
nsim <- 10
nOM <- 2
nMP <- 4
nPI <- 3

values <- array(NA, dim=c(nsim, nOM, nMP, nPI))
pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[,om, mp, pi] <- rlnorm(nsim, log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
boxplot <- Boxplot(Code=c('PI1', 'PI2', 'PI3'),
                   Label=c('Performance Indicator 1',
                           'Performance Indicator 2',
                           'Performance Indicator 3'),
                   Description = c('This is the description for PI 1',
                                   'This is the description for PI 2',
                                   'This is the description for PI 3'),
                   Value=values)

# Check
Check(boxplot)

# Add to `Slick` object
slick <- Slick()
Boxplot(slick) <- boxplot

# Plots
plotBoxplot(slick)

plotBoxplot(slick, type='violin')

plotBoxplot(slick, byOM=TRUE)

plotBoxplot(slick, 2, type='both', byOM=TRUE)

}
\seealso{
\code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Metadata]{Metadata()}}, \code{\link[=Value]{Value()}},
\code{\link[=Preset]{Preset()}}, \code{\link[=Defaults]{Defaults()}}, \code{\link[=plotBoxplot]{plotBoxplot()}}
}
