% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{stdST}
\alias{stdST}
\title{stdST: standard deviation in a moving window}
\usage{
stdST(x, w = 5, ...)
}
\arguments{
\item{x}{A DEM/image as a SpatRaster}

\item{w}{Search window (e.g., kernelCircular(3)), default 5x5 window}

\item{...}{for further use}
}
\value{
the STD of the selected property in the search window (same units of the input)
}
\description{
A function to compute standard deviation in a moving window. By default it uses
the implemented rcpp version that is many times faster that using focal with var() base
R function. It provides the same result as ArcGis Pro. It is intended for computing roughness
indices expressed as dispersion of local surface parameters (e.g., slope, profile curvature, residual surface, etc.).
Whenever there is a NA in the kernel the result is NA.
R base var() function uses n-1 at the denominator, here we use n.
}
\examples{
library(terra)
dem= rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
# std of slope in degrees
slope=terrain(dem, v="slope")
w=KernelCircular(3)
w
stdSlope=stdST(slope,w=w)
plot(stdSlope)
}
\references{
Trevisani, S., Guth, P.L., 2025. Surface Roughness in Geomorphometry: From Basic Metrics Toward a Coherent Framework.
Remote Sensing 17, \doi{doi:10.3390/rs17233864}.
}
